/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling.jboss;

import java.io.File;
import java.io.FilenameFilter;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.sadun.util.polling.ManagedDirectoryPoller;
import org.sadun.util.polling.jboss.ManagedDirectoryPollerServiceMBean;

public class ManagedDirectoryPollerService
implements ManagedDirectoryPollerServiceMBean,
MBeanRegistration,
NotificationListener {
    ManagedDirectoryPoller mPoller;

    public ManagedDirectoryPollerService(File[] dirs, FilenameFilter filter) {
        this.mPoller = new ManagedDirectoryPoller(dirs, filter);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService(File[] dirs) {
        this.mPoller = new ManagedDirectoryPoller(dirs);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService(File directory, FilenameFilter filter) {
        this.mPoller = new ManagedDirectoryPoller(directory, filter);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService(File directory) {
        this.mPoller = new ManagedDirectoryPoller(directory);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService(FilenameFilter filter) {
        this.mPoller = new ManagedDirectoryPoller(filter);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService() {
        this.mPoller = new ManagedDirectoryPoller();
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService(File[] dirs, FilenameFilter filter, boolean timeBased) {
        this.mPoller = new ManagedDirectoryPoller(dirs, filter, timeBased);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService(File directory, FilenameFilter filter, boolean timeBased) {
        this.mPoller = new ManagedDirectoryPoller(directory, filter, timeBased);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public ManagedDirectoryPollerService(FilenameFilter filter, boolean timeBased) {
        this.mPoller = new ManagedDirectoryPoller(filter, timeBased);
        this.mPoller.setJMXTimerObjectName("DefaultDomain:service=timer");
    }

    public void start() {
        this.mPoller.startUp();
    }

    public void stop() {
        this.mPoller.shutdown();
    }

    public void addControlledDirectory(String dir) throws MBeanException {
        this.mPoller.addControlledDirectory(dir);
    }

    public int countControlledDirectories() throws MBeanException {
        return this.mPoller.countControlledDirectories();
    }

    public boolean getAutoMove() {
        return this.mPoller.getAutoMove();
    }

    public String getAutoMoveDirectoryPath(String directory) throws MBeanException {
        return this.mPoller.getAutoMoveDirectoryPath(directory);
    }

    public long getBaseTime(String directory) {
        return this.mPoller.getBaseTime(directory);
    }

    public String getControlledDirectories() {
        return this.mPoller.getControlledDirectories();
    }

    public String getControlledDirectory(int i) throws MBeanException {
        return this.mPoller.getControlledDirectory(i);
    }

    public long getPollInterval() {
        return this.mPoller.getPollInterval();
    }

    public boolean isPollingTimeBased() {
        return this.mPoller.isPollingTimeBased();
    }

    public boolean isRunning() throws MBeanException {
        return this.mPoller.isRunning();
    }

    public boolean isSendSingleFileEvent() {
        return this.mPoller.isSendSingleFileEvent();
    }

    public boolean isStartBySleeping() {
        return this.mPoller.isStartBySleeping();
    }

    public boolean isTimeBased() {
        return this.mPoller.isTimeBased();
    }

    public boolean isVerbose() {
        return this.mPoller.isVerbose();
    }

    public String listControlledDirectories() {
        return this.mPoller.listControlledDirectories();
    }

    public String listInstalledPollManagers() {
        return this.mPoller.listInstalledPollManagers();
    }

    public void removeControlledDirectory(String dir) throws MBeanException {
        this.mPoller.removeControlledDirectory(dir);
    }

    public void setAutoMove(boolean v) {
        this.mPoller.setAutoMove(v);
    }

    public void setBaseTime(String directory, long time) {
        this.mPoller.setBaseTime(directory, time);
    }

    public void setControlledDirectories(String commaSeparatedList) {
        this.mPoller.setControlledDirectories(commaSeparatedList);
    }

    public void setPollingTimeBased(boolean v) {
        this.mPoller.setPollingTimeBased(v);
    }

    public void setPollInterval(long pollInterval) {
        this.mPoller.setPollInterval(pollInterval);
    }

    public void setSendSingleFileEvent(boolean v) {
        this.mPoller.setSendSingleFileEvent(v);
    }

    public void setStartBySleeping(boolean v) {
        this.mPoller.setStartBySleeping(v);
    }

    public void setVerbose(boolean v) {
        this.mPoller.setVerbose(v);
    }

    public void shutDown() throws MBeanException {
        this.mPoller.shutDown();
    }

    public void startUp() throws MBeanException {
        this.mPoller.startUp();
    }

    public String getPollManagerFactoryClass() {
        return this.mPoller.getPollManagerFactoryClass();
    }

    public void setPollManagerFactoryClass(String factoryClass) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.mPoller.setPollManagerFactoryClass(factoryClass);
    }

    public String getPollManagerFactory() {
        return this.mPoller.getPollManagerFactory();
    }

    public String getJMXTimerObjectName() {
        return this.mPoller.getJMXTimerObjectName();
    }

    public boolean isUsingJMXTimer() {
        return this.mPoller.isUsingJMXTimer();
    }

    public void setJMXTimerObjectName(String jMXTimerObjectName) {
        this.mPoller.setJMXTimerObjectName(jMXTimerObjectName);
    }

    public void setUsingJMXTimer(boolean v) {
        this.mPoller.setUsingJMXTimer(v);
    }

    public FilenameFilter getFilter() {
        return this.mPoller.getFilter();
    }

    public void setFilter(FilenameFilter filter) {
        this.mPoller.setFilter(filter);
    }

    public void postDeregister() {
        this.mPoller.postDeregister();
    }

    public void postRegister(Boolean arg0) {
        this.mPoller.postRegister(arg0);
    }

    public void preDeregister() throws Exception {
        this.mPoller.preDeregister();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return this.mPoller.preRegister(server, name);
    }

    public void handleNotification(Notification arg0, Object arg1) {
        this.mPoller.handleNotification(arg0, arg1);
    }

    public void setFilenameFilterFactoryClass(String filenameFilterFactoryClsName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.mPoller.setFilenameFilterFactoryClass(filenameFilterFactoryClsName);
    }

    public String getFilenameFilterFactory() {
        return this.mPoller.getFilenameFilterFactory();
    }

    public String getFilenameFilterFactoryClass() {
        return this.mPoller.getFilenameFilterFactoryClass();
    }

    public String getAcceptedFilenamePattern() {
        return this.mPoller.getAcceptedFilenamePattern();
    }

    public void setAcceptedFilenamePattern(String filenamePattern) {
        this.mPoller.setAcceptedFilenamePattern(filenamePattern);
    }

    public void setAutoMoveDirectoryPath(String directory, String automoveDirectory) {
        this.mPoller.setAutoMoveDirectoryPath(directory, automoveDirectory);
    }

    public String getFilesSortComparatorClass() {
        return this.mPoller.getFilesSortComparatorClass();
    }

    public void setFilesSortComparatorClass(String fileComparatorClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.mPoller.setFilesSortComparatorClass(fileComparatorClassName);
    }

    public String getEventsOrdering() {
        return this.mPoller.getEventsOrdering();
    }

    public void setEventsOrdering(String expr) {
        this.mPoller.setEventsOrdering(expr);
    }

    public String getJMXSequenceNumberGeneratorClass() {
        return this.mPoller.getJMXSequenceNumberGeneratorClass();
    }

    public void setJMXSequenceNumberGeneratorClass(String sequenceNumberGeneratorClass) throws MBeanException {
        this.mPoller.setJMXSequenceNumberGeneratorClass(sequenceNumberGeneratorClass);
    }

    public void addNotificationListener(ObjectName objectName) throws InstanceNotFoundException {
        this.mPoller.addNotificationListener(objectName);
    }

    public void addNotificationListener(String mbeanServerName, ObjectName objectName) throws InstanceNotFoundException {
        this.mPoller.addNotificationListener(mbeanServerName, objectName);
    }

    public void removeNotificationListener(ObjectName objectName) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mPoller.removeNotificationListener(objectName);
    }

    public void removeNotificationListener(String mbeanServerName, ObjectName objectName) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mPoller.removeNotificationListener(mbeanServerName, objectName);
    }

    public boolean isBypassLockedFiles() {
        return this.mPoller.isBypassLockedFiles();
    }

    public void setBypassLockedFiles(boolean supportSlowTransfer) {
        this.mPoller.setBypassLockedFiles(supportSlowTransfer);
    }
}

