/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.io.StreamUtils;
import org.milyn.net.URIUtil;
import org.milyn.profile.DefaultProfileSet;
import org.milyn.profile.ProfileSet;
import org.milyn.resource.URIResourceLocator;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.milyn.xml.LocalDTDEntityResolver;
import org.milyn.xml.LocalEntityResolver;
import org.milyn.xml.LocalXSDEntityResolver;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class XMLConfigDigester {
    private static final String DTD_V10 = "http://www.milyn.org/dtd/smooksres-list-1.0.dtd";
    private static final String XSD_V10 = "http://www.milyn.org/xsd/smooks-1.0.xsd";
    private static Log logger = LogFactory.getLog(XMLConfigDigester.class);

    public static SmooksResourceConfigurationList digestConfig(InputStream stream, String baseURI) throws SAXException, IOException, URISyntaxException {
        SmooksResourceConfigurationList list = new SmooksResourceConfigurationList(baseURI);
        XMLConfigDigester.digestConfig(stream, list, baseURI);
        return list;
    }

    private static void digestConfig(InputStream stream, SmooksResourceConfigurationList list, String baseURI) throws IOException, SAXException, URISyntaxException {
        Document archiveDefDoc;
        LocalEntityResolver entityResolver;
        byte[] streamBuffer = StreamUtils.readStream((InputStream)stream);
        try {
            entityResolver = XMLConfigDigester.getDTDEntityResolver();
            archiveDefDoc = XmlUtil.parseStream((InputStream)new ByteArrayInputStream(streamBuffer), (EntityResolver)entityResolver, (XmlUtil.VALIDATION_TYPE)XmlUtil.VALIDATION_TYPE.DTD, (boolean)true);
        }
        catch (Exception e) {
            entityResolver = XMLConfigDigester.getXSDEntityResolver();
            archiveDefDoc = XmlUtil.parseStream((InputStream)new ByteArrayInputStream(streamBuffer), (EntityResolver)entityResolver, (XmlUtil.VALIDATION_TYPE)XmlUtil.VALIDATION_TYPE.XSD, (boolean)true);
        }
        String docType = entityResolver.getDocType();
        if (DTD_V10.equals(docType)) {
            logger.warn((Object)"Using a deprecated Smooks configuration DTD 'http://www.milyn.org/dtd/smooksres-list-1.0.dtd'.  Update configuration to use XSD 'http://www.milyn.org/xsd/smooks-1.0.xsd'.");
            XMLConfigDigester.digestV10DTDValidatedConfig(archiveDefDoc, list);
            logger.warn((Object)"Using a deprecated Smooks configuration DTD 'http://www.milyn.org/dtd/smooksres-list-1.0.dtd'.  Update configuration to use XSD 'http://www.milyn.org/xsd/smooks-1.0.xsd'.");
        } else if (XSD_V10.equals(docType)) {
            XMLConfigDigester.digestV10XSDValidatedConfig(baseURI, archiveDefDoc, list);
        } else {
            throw new SAXException("Invalid Content Delivery Resource archive definition file: Must be validated against one of - 'http://www.milyn.org/dtd/smooksres-list-1.0.dtd' or 'http://www.milyn.org/xsd/smooks-1.0.xsd'.");
        }
        if (list.isEmpty()) {
            throw new SAXException("Invalid Content Delivery Resource archive definition file: 0 Content Delivery Resource definitions.");
        }
    }

    private static LocalEntityResolver getDTDEntityResolver() {
        return new LocalDTDEntityResolver();
    }

    private static LocalEntityResolver getXSDEntityResolver() {
        StreamSource schemaSource = new StreamSource(ClassUtil.getResourceAsStream((String)"/org/milyn/xsd/smooks-1.0.xsd", XMLConfigDigester.class), XSD_V10);
        return new LocalXSDEntityResolver(new Source[]{schemaSource});
    }

    private static void digestV10DTDValidatedConfig(Document configDoc, SmooksResourceConfigurationList list) throws SAXException {
        int cdrIndex = 1;
        Element currentElement = (Element)XmlUtil.getNode((Node)configDoc, (String)"/smooks-resource-list");
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-namespace");
        String defaultUseragent = DomUtils.getAttributeValue(currentElement, "default-useragent");
        String defaultPath = DomUtils.getAttributeValue(currentElement, "default-path");
        String resourceSelector = "/smooks-resource-list/smooks-resource[" + cdrIndex + "]";
        while ((currentElement = (Element)XmlUtil.getNode((Node)configDoc, (String)resourceSelector)) != null) {
            SmooksResourceConfiguration resourceConfig;
            String selector = DomUtils.getAttributeValue(currentElement, "selector");
            String namespace = DomUtils.getAttributeValue(currentElement, "namespace");
            String useragents = DomUtils.getAttributeValue(currentElement, "useragent");
            String path = DomUtils.getAttributeValue(currentElement, "path");
            try {
                resourceConfig = new SmooksResourceConfiguration(selector != null ? selector : defaultSelector, namespace != null ? namespace : defaultNamespace, useragents != null ? useragents : defaultUseragent, path != null ? path : defaultPath);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Invalid unit definition.", e);
            }
            XMLConfigDigester.digestParameters(currentElement, resourceConfig);
            list.add(resourceConfig);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding smooks-resource config from [" + list.getName() + "]: " + resourceConfig));
            }
            resourceSelector = "/smooks-resource-list/smooks-resource[" + ++cdrIndex + "]";
        }
    }

    private static void digestV10XSDValidatedConfig(String baseURI, Document configDoc, SmooksResourceConfigurationList list) throws SAXException, URISyntaxException {
        Element currentElement = (Element)XmlUtil.getNode((Node)configDoc, (String)"/smooks-resource-list");
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-selector-namespace");
        String defaultProfile = DomUtils.getAttributeValue(currentElement, "default-target-profile");
        NodeList configElements = XmlUtil.getNodeList((Node)currentElement, (String)"*");
        for (int i = 0; i < configElements.getLength(); ++i) {
            Element configElement = (Element)configElements.item(i);
            if (DomUtils.getName(configElement).equals("profiles")) {
                XMLConfigDigester.digestProfiles(configElement, list);
                continue;
            }
            if (DomUtils.getName(configElement).equals("import")) {
                XMLConfigDigester.digestImport(configElement, new URI(baseURI), list);
                continue;
            }
            if (!DomUtils.getName(configElement).equals("resource-config")) continue;
            XMLConfigDigester.digestResourceConfig(configElement, defaultSelector, defaultNamespace, defaultProfile, list);
        }
    }

    private static void digestImport(Element configElement, URI baseURI, SmooksResourceConfigurationList list) throws SAXException, URISyntaxException {
        String file = DomUtils.getAttributeValue(configElement, "file");
        if (file == null) {
            throw new IllegalStateException("Invalid resource import.  'file' attribute must be specified.");
        }
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(baseURI);
        try {
            URI fileURI = resourceLocator.resolveURI(file);
            if (list.addSourceResourceURI(fileURI)) {
                InputStream resourceStream = resourceLocator.getResource(file);
                XMLConfigDigester.digestConfig(resourceStream, list, URIUtil.getParent((URI)fileURI).toString());
            }
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load Smooks configuration resource <import> '" + file + "': " + e.getMessage()));
        }
    }

    private static void digestResourceConfig(Element configElement, String defaultSelector, String defaultNamespace, String defaultProfile, SmooksResourceConfigurationList list) throws SAXException {
        SmooksResourceConfiguration resourceConfig;
        String selector = DomUtils.getAttributeValue(configElement, "selector");
        String namespace = DomUtils.getAttributeValue(configElement, "selector-namespace");
        String profiles = DomUtils.getAttributeValue(configElement, "target-profile");
        Element resourceElement = (Element)XmlUtil.getNode((Node)configElement, (String)"resource");
        String resource = null;
        try {
            if (resourceElement != null) {
                resource = DomUtils.getAllText(resourceElement, true);
            }
            resourceConfig = new SmooksResourceConfiguration(selector != null ? selector : defaultSelector, namespace != null ? namespace : defaultNamespace, profiles != null ? profiles : defaultProfile, resource);
            if (resourceElement != null) {
                resourceConfig.setResourceType(DomUtils.getAttributeValue(resourceElement, "type"));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SAXException("Invalid unit definition.", e);
        }
        XMLConfigDigester.digestParameters(configElement, resourceConfig);
        list.add(resourceConfig);
        if (resource == null) {
            if (resourceConfig.getParameters("resdata") != null) {
                logger.warn((Object)("Resource 'null' for resource config: " + resourceConfig + ".  This is probably an error because the configuration contains a 'resdata' param, which suggests it is following the old DTD based configuration model.  The new model requires the resource to be specified in the <resource> element."));
            } else {
                logger.debug((Object)("Resource 'null' for resource config: " + resourceConfig + ". This is not invalid!"));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding smooks-resource config from [" + list.getName() + "]: " + resourceConfig));
        }
    }

    private static void digestProfiles(Element profilesElement, SmooksResourceConfigurationList list) {
        Element profileNode;
        int profileIndex = 1;
        String profileSelector = null;
        profileSelector = "profile[" + profileIndex + "]";
        while ((profileNode = (Element)XmlUtil.getNode((Node)profilesElement, (String)profileSelector)) != null) {
            String baseProfile = DomUtils.getAttributeValue(profileNode, "base-profile");
            String subProfiles = DomUtils.getAttributeValue(profileNode, "sub-profiles");
            DefaultProfileSet profileSet = new DefaultProfileSet(baseProfile);
            if (subProfiles != null) {
                profileSet.addProfiles(subProfiles.split(","));
            }
            list.add((ProfileSet)profileSet);
            profileSelector = "profile[" + ++profileIndex + "]";
        }
    }

    private static void digestParameters(Element resourceConfigElement, SmooksResourceConfiguration resourceConfig) {
        Element paramNode;
        int paramIndex = 1;
        String paramSelector = null;
        paramSelector = "param[" + paramIndex + "]";
        while ((paramNode = (Element)XmlUtil.getNode((Node)resourceConfigElement, (String)paramSelector)) != null) {
            String paramName = DomUtils.getAttributeValue(paramNode, "name");
            String paramType = DomUtils.getAttributeValue(paramNode, "type");
            String paramValue = DomUtils.getAllText(paramNode, true);
            Parameter paramInstance = resourceConfig.setParameter(paramName, paramType, paramValue);
            paramInstance.setXML(paramNode);
            paramSelector = "param[" + ++paramIndex + "]";
        }
    }
}

