/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.container.standalone;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.container.standalone.StandaloneApplicationContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.dom.ContentDeliveryConfigImpl;
import org.milyn.profile.ProfileSet;
import org.milyn.profile.UnknownProfileMemberException;

public class StandaloneExecutionContext
implements ExecutionContext {
    private ProfileSet targetProfileSet;
    private Hashtable attributes = new Hashtable();
    private Hashtable elementListTable = new Hashtable();
    private ContentDeliveryConfig deliveryConfig;
    private URI docSource;
    private LinkedHashMap parameters;
    private String contentEncoding;
    private StandaloneApplicationContext context;

    public StandaloneExecutionContext(String targetProfile, StandaloneApplicationContext context) throws UnknownProfileMemberException {
        this(targetProfile, null, context);
    }

    public StandaloneExecutionContext(String targetProfile, LinkedHashMap parameters, StandaloneApplicationContext context) throws UnknownProfileMemberException {
        this(targetProfile, parameters, context, "UTF-8");
    }

    public StandaloneExecutionContext(String targetProfile, LinkedHashMap parameters, StandaloneApplicationContext context, String contentEncoding) throws UnknownProfileMemberException {
        if (targetProfile == null) {
            throw new IllegalArgumentException("null 'targetProfile' arg in constructor call.");
        }
        if (context == null) {
            throw new IllegalArgumentException("null 'context' arg in constructor call.");
        }
        this.parameters = parameters != null ? parameters : new LinkedHashMap();
        this.context = context;
        this.setContentEncoding(contentEncoding);
        this.targetProfileSet = context.getProfileStore().getProfileSet(targetProfile);
        this.deliveryConfig = ContentDeliveryConfigImpl.getInstance(this.targetProfileSet, context);
    }

    public void setDocumentSource(URI docSource) {
        this.docSource = docSource;
    }

    public URI getDocumentSource() {
        if (this.docSource == null) {
            return ExecutionContext.DOCUMENT_URI;
        }
        return this.docSource;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public ProfileSet getTargetProfiles() {
        return this.targetProfileSet;
    }

    public ContentDeliveryConfig getDeliveryConfig() {
        return this.deliveryConfig;
    }

    public void setContentEncoding(String contentEncoding) throws IllegalArgumentException {
        contentEncoding = contentEncoding == null ? "UTF-8" : contentEncoding;
        try {
            "".getBytes(contentEncoding);
        }
        catch (UnsupportedEncodingException e) {
            IllegalArgumentException argE = new IllegalArgumentException("Invalid 'contentEncoding' arg [" + contentEncoding + "].  This encoding is not supported.");
            argE.initCause(e);
            throw argE;
        }
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding == null ? "UTF-8" : this.contentEncoding;
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }
}

