/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryUnitConfigMap;
import org.milyn.dtd.DTDStore;
import org.milyn.xml.Namespace;
import org.milyn.xml.SmooksXMLReader;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Parser {
    private static Log logger = LogFactory.getLog(Parser.class);
    private static DocumentBuilder documentBuilder;
    private ExecutionContext request;
    private HashSet emptyElements = new HashSet();
    private SmooksResourceConfiguration saxDriverConfig;

    public Parser() {
    }

    public Parser(ExecutionContext request) {
        if (request == null) {
            throw new IllegalArgumentException("null 'request' arg in method call.");
        }
        this.request = request;
        this.initialiseEmptyElements();
        this.saxDriverConfig = Parser.getSAXParserConfiguration(request.getDeliveryConfig());
    }

    public Parser(ExecutionContext request, SmooksResourceConfiguration saxDriverConfig) {
        this(request);
        this.saxDriverConfig = saxDriverConfig;
        if (saxDriverConfig.getResource() == null) {
            throw new IllegalStateException("Invalid SAX Parser configuration.  Must specify 'path' attribute to contain the parser class name.");
        }
    }

    public static SmooksResourceConfiguration getSAXParserConfiguration(ContentDeliveryConfig deliveryConfig) {
        if (deliveryConfig == null) {
            throw new IllegalArgumentException("null 'deliveryConfig' arg in method call.");
        }
        SmooksResourceConfiguration saxDriverConfig = null;
        List<ContentDeliveryUnitConfigMap> saxConfigs = deliveryConfig.getSmooksResourceConfigurations("org.xml.sax.driver");
        if (saxConfigs != null && !saxConfigs.isEmpty() && (saxDriverConfig = (SmooksResourceConfiguration)((Object)saxConfigs.get(0))).getResource() == null) {
            throw new IllegalStateException("Invalid SAX Parser configuration.  Must specify 'path' attribute to contain the parser class name.");
        }
        return saxDriverConfig;
    }

    private void initialiseEmptyElements() {
        String[] emptyEls;
        DTDStore.DTDObjectContainer dtd = this.request.getDeliveryConfig().getDTD();
        if (dtd != null && (emptyEls = dtd.getEmptyElements()) != null && emptyEls.length > 0) {
            for (int i = 0; i < emptyEls.length; ++i) {
                this.emptyElements.add(emptyEls[i]);
            }
        }
    }

    public Document parse(Reader source) throws IOException, SAXException {
        SmooksContentHandler contentHandler = new SmooksContentHandler();
        this.parse(source, contentHandler);
        return contentHandler.getDocument();
    }

    public void append(Reader source, Element appendElement) throws IOException, SAXException {
        SmooksContentHandler contentHandler = new SmooksContentHandler();
        contentHandler.setAppendElement(appendElement);
        this.parse(source, contentHandler);
    }

    private void parse(Reader source, SmooksContentHandler contentHandler) throws SAXException, IOException {
        XMLReader reader;
        if (this.saxDriverConfig != null) {
            reader = XMLReaderFactory.createXMLReader(this.saxDriverConfig.getResource());
            if (reader instanceof SmooksXMLReader) {
                ((SmooksXMLReader)reader).setConfiguration(this.saxDriverConfig);
                ((SmooksXMLReader)reader).setExecutionContext(this.request);
            }
        } else {
            reader = XMLReaderFactory.createXMLReader();
        }
        reader.setContentHandler(contentHandler);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        reader.parse(new InputSource(source));
    }

    static {
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            IllegalStateException state = new IllegalStateException("XML DOM Parsing environment not configured properly.");
            state.initCause(e);
            throw state;
        }
    }

    private class SmooksContentHandler
    implements ContentHandler,
    LexicalHandler {
        private Document ownerDocument;
        private Stack nodeStack = new Stack();
        private boolean inEntity = false;

        private SmooksContentHandler() {
        }

        public void startDocument() throws SAXException {
            if (this.ownerDocument == null) {
                this.ownerDocument = documentBuilder.newDocument();
                this.nodeStack.push(this.ownerDocument);
            }
        }

        public Document getDocument() {
            return this.ownerDocument;
        }

        private void setAppendElement(Element appendElement) {
            this.ownerDocument = appendElement.getOwnerDocument();
            this.nodeStack.push(appendElement);
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            Element newElement = null;
            int attsCount = atts.getLength();
            Node currentNode = (Node)this.nodeStack.peek();
            try {
                newElement = namespaceURI != null && qName != null && !qName.equals("") ? this.ownerDocument.createElementNS(namespaceURI.intern(), qName) : this.ownerDocument.createElement(localName.intern());
                currentNode.appendChild(newElement);
                if (!Parser.this.emptyElements.contains(qName != null ? qName.toLowerCase() : localName.toLowerCase())) {
                    this.nodeStack.push(newElement);
                }
            }
            catch (DOMException e) {
                logger.error((Object)("DOMException creating start element: namespaceURI=" + namespaceURI + ", localName=" + localName), (Throwable)e);
                throw e;
            }
            for (int i = 0; i < attsCount; ++i) {
                String attNamespace = atts.getURI(i);
                String attQName = atts.getQName(i);
                String attLocalName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                try {
                    if (attNamespace != null && attQName != null) {
                        if ((attNamespace = attNamespace.intern()).equals("")) {
                            if (attQName.startsWith("xmlns")) {
                                attNamespace = Namespace.XMLNS_URI;
                            } else if (attQName.startsWith("xml:")) {
                                attNamespace = Namespace.XML_URI;
                            }
                        }
                        newElement.setAttributeNS(attNamespace, attQName, attValue);
                        continue;
                    }
                    newElement.setAttribute(attLocalName.intern(), attValue);
                    continue;
                }
                catch (DOMException e) {
                    logger.error((Object)("DOMException setting element attribute " + attLocalName + "=" + attValue + "[namespaceURI=" + namespaceURI + ", localName=" + localName + "]."), (Throwable)e);
                    throw e;
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String elName = qName != null && !qName.equals("") ? qName.toLowerCase() : localName.toLowerCase();
            if (!Parser.this.emptyElements.contains(elName)) {
                int index = this.getIndex(elName);
                if (index != -1) {
                    this.nodeStack.setSize(index);
                } else {
                    logger.warn((Object)("Ignoring unexpected end [" + localName + "] element event. Request: [" + Parser.this.request.getDocumentSource() + "] - document location: [" + this.getCurPath() + "]"));
                }
            }
        }

        private String getCurPath() {
            StringBuffer path = new StringBuffer();
            int stackSize = this.nodeStack.size();
            for (int i = 0; i < stackSize; ++i) {
                Node node = (Node)this.nodeStack.elementAt(i);
                if (node.getNodeType() != 1) continue;
                path.append('/').append(((Element)node).getTagName());
            }
            return path.toString();
        }

        private int getIndex(String elName) {
            for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
                Element element;
                Node node = (Node)this.nodeStack.elementAt(i);
                if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().toLowerCase().equals(elName)) continue;
                return i;
            }
            return -1;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                Node currentNode = (Node)this.nodeStack.peek();
                switch (currentNode.getNodeType()) {
                    case 1: {
                        if (this.inEntity) {
                            currentNode.appendChild(this.ownerDocument.createTextNode("&#" + ch[0] + ";"));
                            break;
                        }
                        currentNode.appendChild(this.ownerDocument.createTextNode(new String(ch, start, length)));
                        break;
                    }
                    case 4: {
                        ((CDATASection)currentNode).setData(new String(ch, start, length));
                        break;
                    }
                }
            }
            catch (DOMException e) {
                logger.error((Object)("DOMException appending character data [" + new String(ch, start, length) + "]"), (Throwable)e);
                throw e;
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        public void startCDATA() throws SAXException {
            CDATASection newCDATASection = this.ownerDocument.createCDATASection("dummy");
            Node currentNode = (Node)this.nodeStack.peek();
            currentNode.appendChild(newCDATASection);
            this.nodeStack.push(newCDATASection);
        }

        public void endCDATA() throws SAXException {
            this.nodeStack.pop();
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                Node currentNode = (Node)this.nodeStack.peek();
                Comment newComment = this.ownerDocument.createComment(new String(ch, start, length));
                currentNode.appendChild(newComment);
            }
            catch (DOMException e) {
                logger.error((Object)("DOMException comment data [" + new String(ch, start, length) + "]"), (Throwable)e);
                throw e;
            }
        }

        public void startEntity(String name) throws SAXException {
            this.inEntity = true;
        }

        public void endEntity(String name) throws SAXException {
            this.inEntity = false;
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            DocumentType docType = documentBuilder.getDOMImplementation().createDocumentType(name, publicId, systemId);
            this.ownerDocument.appendChild(docType);
        }

        public void endDTD() throws SAXException {
        }
    }
}

