/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.Iterator;
import org.drools.RuntimeDroolsException;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;

public class GroupElementBuilder
implements RuleConditionBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        ConditionalElementDescr cedescr = (ConditionalElementDescr)((Object)descr);
        GroupElement ge = this.newGroupElementFor(cedescr.getClass());
        context.getBuildStack().push(ge);
        if (prefixPattern != null) {
            ge.addChild((RuleConditionElement)prefixPattern);
        }
        Iterator it = cedescr.getDescrs().iterator();
        while (it.hasNext()) {
            BaseDescr child = (BaseDescr)it.next();
            RuleConditionBuilder builder = context.getDialect().getBuilder(child.getClass());
            if (builder != null) {
                RuleConditionElement element = builder.build(context, child);
                if (element == null) continue;
                ge.addChild(element);
                continue;
            }
            throw new RuntimeDroolsException("BUG: no builder found for descriptor class " + child.getClass());
        }
        context.getBuildStack().pop();
        return ge;
    }

    private GroupElement newGroupElementFor(Class descr) {
        if (AndDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newAndInstance();
        }
        if (OrDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newOrInstance();
        }
        if (NotDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newNotInstance();
        }
        if (ExistsDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newExistsInstance();
        }
        throw new RuntimeDroolsException("BUG: Not able to create a group element for descriptor: " + descr.getName());
    }
}

