/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceTable
extends AbstractSwingXFormField<JPanel> {
    private JTable table;
    private JScrollPane scrollPane;
    private final Interface iface;
    private NamespaceTableModel namespaceTableModel;

    public NamespaceTable(Interface iface) {
        super(new JPanel(new BorderLayout()));
        this.iface = iface;
        this.namespaceTableModel = new NamespaceTableModel();
        this.table = new JTable(this.namespaceTableModel);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(300, 150));
        ((JPanel)this.getComponent()).add((Component)this.scrollPane, "Center");
    }

    public JPanel getComponent(XForm.ToolkitType toolkitType) {
        if (toolkitType == XForm.ToolkitType.SWT) {
            UISupport.showErrorMessage("SWT not supported by namespace table");
            return null;
        }
        return (JPanel)this.getComponent();
    }

    @Override
    public void setValue(String value) {
        this.namespaceTableModel.setMappings(StringToStringMap.fromXml(value));
    }

    @Override
    public String getValue() {
        return this.namespaceTableModel.getMappings().toXml();
    }

    @Override
    public boolean isMultiRow() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamespaceTableModel
    extends AbstractTableModel {
        private List<String> namespaces = new ArrayList<String>();
        private List<String> packages;

        public NamespaceTableModel() {
            try {
                if (NamespaceTable.this.iface != null) {
                    this.namespaces.addAll(NamespaceTable.this.iface.getWsdlContext().getDefinedNamespaces());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.packages = new ArrayList<String>(Arrays.asList(new String[this.namespaces.size()]));
        }

        public void setMappings(StringToStringMap mapping) {
            for (int c = 0; c < this.namespaces.size(); ++c) {
                if (mapping.containsKey(this.namespaces.get(c))) {
                    this.packages.set(c, (String)mapping.get(this.namespaces.get(c)));
                    continue;
                }
                this.packages.set(c, "");
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.namespaces.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Namespace" : "Package";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                this.packages.set(rowIndex, aValue.toString());
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.namespaces.get(rowIndex);
            }
            return this.packages.get(rowIndex);
        }

        public StringToStringMap getMappings() {
            StringToStringMap result = new StringToStringMap();
            for (int c = 0; c < this.namespaces.size(); ++c) {
                String pkg = this.packages.get(c);
                if (pkg == null || pkg.trim().length() <= 0) continue;
                result.put(this.namespaces.get(c), pkg.trim());
            }
            return result;
        }
    }
}

