/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.LoadTestLimitTypesConfig;
import com.eviware.soapui.impl.wsdl.actions.loadtest.LoadTestOptionsAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestRunner;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportStatisticsAction;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyRegistry;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JLoadTestAssertionsTable;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JLoadTestLogTable;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JStatisticsTable;
import com.eviware.soapui.impl.wsdl.panels.loadtest.StatisticsDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.loadtest.StatisticsHistoryDesktopPanel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DesktopListenerAdapter;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlLoadTestDesktopPanel
extends ModelItemDesktopPanel<WsdlLoadTest>
implements PropertyChangeListener {
    private JPanel contentPanel;
    private JSplitPane mainSplit;
    private JTabbedPane mainTabs;
    private JPanel graphPanel;
    private JButton runButton;
    private JButton cancelButton;
    private JButton statisticsGraphButton;
    private WsdlLoadTestRunner runner;
    private JSpinner threadsSpinner;
    private LoadTestRunListener internalLoadTestListener = new InternalLoadTestListener();
    private JComboBox strategyCombo;
    private JPanel loadStrategyConfigurationPanel;
    private JButton resetButton;
    private LoadTestLog loadTestLog;
    private JButton optionsButton;
    private JButton testTimesGraphButton;
    private Object limit;
    private JSpinner limitSpinner;
    private JComboBox limitTypeCombo;
    private SpinnerNumberModel limitSpinnerModel;
    private JProgressBar progressBar;
    private long loadTestStartTime;
    private StatisticsDesktopPanel statisticsDesktopPanel;
    private StatisticsHistoryDesktopPanel statisticsHistoryDesktopPanel;
    public boolean loadTestIsRunning;
    private InternalDesktopListener desktopListener;
    private JButton exportButton;
    private JLoadTestAssertionsTable assertionsTable;

    public WsdlLoadTestDesktopPanel(WsdlLoadTest loadTest) {
        super(loadTest);
        this.loadTestLog = loadTest.getLoadTestLog();
        loadTest.addPropertyChangeListener(WsdlLoadTest.THREADCOUNT_PROPERTY, this);
        loadTest.addLoadTestRunListener(this.internalLoadTestListener);
        this.desktopListener = new InternalDesktopListener();
        this.buildUI();
    }

    private void buildUI() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.add((Component)this.buildToolbar(), "North");
        this.contentPanel.add((Component)this.buildContent(), "Center");
        this.contentPanel.setPreferredSize(new Dimension(600, 500));
    }

    private JComponent buildContent() {
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.addTab("LoadTest Log", this.buildLog());
        tabbedPane.addTab("LoadTest Assertions", this.buildAssertions());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)tabbedPane, "Center");
        p.setBackground(Color.LIGHT_GRAY);
        JSplitPane mainSplit = UISupport.createVerticalSplit(this.buildStatistics(), p);
        mainSplit.setDividerLocation(150);
        return mainSplit;
    }

    private JComponent buildStatistics() {
        return new JStatisticsTable((WsdlLoadTest)this.getModelItem());
    }

    private JComponent buildLog() {
        JLoadTestLogTable loadTestLogTable = new JLoadTestLogTable(this.loadTestLog);
        return loadTestLogTable;
    }

    private JComponent buildAssertions() {
        this.assertionsTable = new JLoadTestAssertionsTable((WsdlLoadTest)this.getModelItem());
        return this.assertionsTable;
    }

    private JComponent buildToolbar() {
        WsdlLoadTest loadTest = (WsdlLoadTest)this.getModelItem();
        JXToolBar toolbar = UISupport.createToolbar();
        this.runButton = UISupport.createToolbarButton(new RunLoadTestAction());
        this.cancelButton = UISupport.createToolbarButton(new CancelRunTestCaseAction(), false);
        this.resetButton = UISupport.createToolbarButton(new ResetAction());
        this.exportButton = UISupport.createToolbarButton(new ExportStatisticsAction(loadTest.getStatisticsModel()));
        this.statisticsGraphButton = UISupport.createToolbarButton(new ShowStatisticsGraphAction());
        this.testTimesGraphButton = UISupport.createToolbarButton(new ShowTestTimesGraphAction());
        this.optionsButton = UISupport.createToolbarButton(new LoadTestOptionsAction((WsdlLoadTest)this.getModelItem()));
        this.strategyCombo = new JComboBox<Object>(LoadStrategyRegistry.getInstance().getStrategies());
        UISupport.setPreferredHeight(this.strategyCombo, 18);
        this.strategyCombo.setSelectedItem(loadTest.getLoadStrategy().getType());
        this.strategyCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (item == null) {
                    return;
                }
                WsdlLoadTestDesktopPanel.this.setLoadStrategy(item.toString());
            }
        });
        toolbar.add(this.runButton);
        toolbar.add(this.cancelButton);
        toolbar.add(this.statisticsGraphButton);
        toolbar.add(this.testTimesGraphButton);
        toolbar.add(this.resetButton);
        toolbar.add(this.exportButton);
        toolbar.add(this.optionsButton);
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/loadtest/index.html#The_LoadTest_Editor")));
        toolbar.add(Box.createHorizontalGlue());
        this.buildLimitBar(toolbar);
        toolbar.addSeparator();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(70, 20));
        toolbar.addFixed(this.progressBar);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("Threads:"));
        builder.addRelatedGap();
        this.threadsSpinner = new JSpinner(new SpinnerNumberModel(((WsdlLoadTest)this.getModelItem()).getThreadCount(), 1.0, 9999.0, 1.0));
        UISupport.setPreferredHeight(this.threadsSpinner, 18);
        this.threadsSpinner.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setThreadCount(((SpinnerNumberModel)WsdlLoadTestDesktopPanel.this.threadsSpinner.getModel()).getNumber().intValue());
            }
        });
        builder.addFixed((JComponent)this.threadsSpinner);
        builder.addUnrelatedGap();
        LoadStrategy loadStrategy = loadTest.getLoadStrategy();
        builder.addFixed((JComponent)new JLabel("Strategy"));
        builder.addRelatedGap();
        builder.addFixed((JComponent)this.strategyCombo);
        builder.addUnrelatedGap();
        this.loadStrategyConfigurationPanel = new JPanel(new BorderLayout());
        this.loadStrategyConfigurationPanel.add((Component)loadStrategy.getConfigurationPanel(), "Center");
        builder.addFixed((JComponent)this.loadStrategyConfigurationPanel);
        builder.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 3));
        return UISupport.buildPanelWithToolbar(toolbar, builder.getPanel());
    }

    public void buildLimitBar(JXToolBar toolbar) {
        this.limitSpinnerModel = new SpinnerNumberModel(((WsdlLoadTest)this.getModelItem()).getTestLimit(), 0.0, 9.223372036854776E18, 100.0);
        this.limitSpinner = new JSpinner(this.limitSpinnerModel);
        this.limitSpinner.setPreferredSize(new Dimension(70, 20));
        this.limitSpinner.setToolTipText("Sets the limit for this test; requests per thread or seconds");
        this.limitSpinner.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int intValue = ((SpinnerNumberModel)WsdlLoadTestDesktopPanel.this.limitSpinner.getModel()).getNumber().intValue();
                ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setTestLimit(intValue);
            }
        });
        toolbar.addSeparator();
        toolbar.addFixed(new JLabel("Limit:"));
        toolbar.addSeparator();
        toolbar.addFixed(this.limitSpinner);
        toolbar.addSeparator();
        this.limitTypeCombo = new JComboBox<String>(new String[]{"Runs", "Seconds"});
        if (((WsdlLoadTest)this.getModelItem()).getLimitType() == LoadTestLimitTypesConfig.TIME) {
            this.limitTypeCombo.setSelectedIndex(1);
        }
        toolbar.addFixed(this.limitTypeCombo);
        toolbar.addSeparator();
        this.limitTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if ("Runs".equals(item)) {
                    ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setLimitType(LoadTestLimitTypesConfig.COUNT);
                } else if ("Seconds".equals(item)) {
                    ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setLimitType(LoadTestLimitTypesConfig.TIME);
                }
            }
        });
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (this.runner != null && this.runner.getStatus() == LoadTestRunner.Status.RUNNING && !UISupport.confirm("Running test will be canceled when closing window. Close anyway?", "Close LoadTest")) {
            return false;
        }
        ((WsdlLoadTest)this.getModelItem()).removeLoadTestRunListener(this.internalLoadTestListener);
        ((WsdlLoadTest)this.getModelItem()).removePropertyChangeListener(WsdlLoadTest.THREADCOUNT_PROPERTY, this);
        if (this.runner != null && this.runner.getStatus() == LoadTestRunner.Status.RUNNING) {
            this.runner.cancel("closing window");
        }
        if (this.statisticsDesktopPanel != null) {
            SoapUI.getDesktop().closeDesktopPanel(this.statisticsDesktopPanel);
        }
        if (this.statisticsHistoryDesktopPanel != null) {
            SoapUI.getDesktop().closeDesktopPanel(this.statisticsHistoryDesktopPanel);
        }
        this.assertionsTable.release();
        SoapUI.getDesktop().removeDesktopListener(this.desktopListener);
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this.contentPanel;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        WsdlLoadTest loadTest = (WsdlLoadTest)this.getModelItem();
        return modelItem == loadTest || modelItem == loadTest.getTestCase() || modelItem == loadTest.getTestCase().getTestSuite() || modelItem == loadTest.getTestCase().getTestSuite().getProject();
    }

    public void setLoadStrategy(String type) {
        LoadStrategyFactory factory = LoadStrategyRegistry.getInstance().getFactory(type);
        LoadStrategy loadStrategy = factory.create();
        ((WsdlLoadTest)this.getModelItem()).setLoadStrategy(loadStrategy);
        this.loadStrategyConfigurationPanel.removeAll();
        this.loadStrategyConfigurationPanel.add((Component)loadStrategy.getConfigurationPanel(), "Center");
        this.loadStrategyConfigurationPanel.revalidate();
    }

    @Override
    public String getDescription() {
        return "LoadTest: [" + ((WsdlLoadTest)this.getModelItem()).getName() + "] for TestCase [" + ((WsdlLoadTest)this.getModelItem()).getTestCase().getName() + "] in TestSuite [" + ((WsdlLoadTest)this.getModelItem()).getTestCase().getTestSuite().getName() + "]";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(WsdlLoadTest.THREADCOUNT_PROPERTY)) {
            this.threadsSpinner.setValue(evt.getNewValue());
        }
    }

    private class ProgressBarUpdater
    implements Runnable {
        private ProgressBarUpdater() {
        }

        public void run() {
            while (WsdlLoadTestDesktopPanel.this.loadTestIsRunning) {
                if (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTestLimit() == 0L) {
                    if (WsdlLoadTestDesktopPanel.this.loadTestIsRunning && !WsdlLoadTestDesktopPanel.this.progressBar.isIndeterminate()) {
                        WsdlLoadTestDesktopPanel.this.progressBar.setIndeterminate(true);
                        WsdlLoadTestDesktopPanel.this.progressBar.setString("...");
                    }
                } else if (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getLimitType() == LoadTestLimitTypesConfig.TIME) {
                    if (WsdlLoadTestDesktopPanel.this.loadTestIsRunning && WsdlLoadTestDesktopPanel.this.progressBar.isIndeterminate()) {
                        WsdlLoadTestDesktopPanel.this.progressBar.setIndeterminate(false);
                        WsdlLoadTestDesktopPanel.this.progressBar.setString(null);
                    }
                    long timePassed = System.currentTimeMillis() - WsdlLoadTestDesktopPanel.this.loadTestStartTime;
                    int value = (int)(timePassed * 100L / (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTestLimit() * 1000L));
                    WsdlLoadTestDesktopPanel.this.progressBar.setValue(value);
                } else if (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getLimitType() == LoadTestLimitTypesConfig.COUNT) {
                    long counts;
                    if (WsdlLoadTestDesktopPanel.this.loadTestIsRunning && WsdlLoadTestDesktopPanel.this.progressBar.isIndeterminate()) {
                        WsdlLoadTestDesktopPanel.this.progressBar.setIndeterminate(false);
                        WsdlLoadTestDesktopPanel.this.progressBar.setString(null);
                    }
                    if ((counts = ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getStatisticsModel().getStatistic(-1, LoadTestStatistics.Statistic.COUNT)) > 0L) {
                        WsdlLoadTestDesktopPanel.this.progressBar.setValue((int)(counts * 100L / ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTestLimit()));
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class InternalLoadTestListener
    extends LoadTestRunListenerAdapter {
        private InternalLoadTestListener() {
        }

        public void beforeLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            WsdlLoadTestDesktopPanel.this.loadTestLog.clear();
            WsdlLoadTestDesktopPanel.this.loadTestStartTime = System.currentTimeMillis();
            WsdlLoadTestDesktopPanel.this.loadTestIsRunning = true;
            if (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTestLimit() > 0L) {
                WsdlLoadTestDesktopPanel.this.progressBar.setValue(0);
                WsdlLoadTestDesktopPanel.this.progressBar.setString(null);
            } else {
                WsdlLoadTestDesktopPanel.this.progressBar.setString("...");
            }
            WsdlLoadTestDesktopPanel.this.progressBar.setStringPainted(true);
            WsdlLoadTestDesktopPanel.this.runButton.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.cancelButton.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.strategyCombo.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.limitTypeCombo.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.threadsSpinner.setEnabled(((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getLoadStrategy().allowThreadCountChangeDuringRun());
            new Thread(new ProgressBarUpdater()).start();
        }

        public void afterLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            WsdlLoadTestDesktopPanel.this.runButton.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.cancelButton.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.strategyCombo.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.limitTypeCombo.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.threadsSpinner.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.runner = null;
            WsdlLoadTestDesktopPanel.this.loadTestIsRunning = false;
            if (WsdlLoadTestDesktopPanel.this.progressBar.isIndeterminate()) {
                WsdlLoadTestDesktopPanel.this.progressBar.setIndeterminate(false);
                WsdlLoadTestDesktopPanel.this.progressBar.setValue(0);
            } else if (testRunner.getStatus() == LoadTestRunner.Status.FINISHED) {
                WsdlLoadTestDesktopPanel.this.progressBar.setValue(100);
            }
            if (testRunner.getStatus() == LoadTestRunner.Status.FAILED) {
                UISupport.showErrorMessage("LoadTest failed");
            }
        }
    }

    public class CancelRunTestCaseAction
    extends AbstractAction {
        public CancelRunTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop_testcase.gif"));
            this.putValue("ShortDescription", "Stops running this LoadTest");
        }

        public void actionPerformed(ActionEvent e) {
            if (WsdlLoadTestDesktopPanel.this.runner != null) {
                WsdlLoadTestDesktopPanel.this.runner.cancel("Canceled");
            }
            WsdlLoadTestDesktopPanel.this.cancelButton.setEnabled(false);
        }
    }

    public class ShowTestTimesGraphAction
    extends AbstractAction {
        public ShowTestTimesGraphAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/samples_graph.gif"));
            this.putValue("ShortDescription", "Shows the Statistics History graph");
        }

        public void actionPerformed(ActionEvent e) {
            if (WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel == null) {
                WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel = new StatisticsHistoryDesktopPanel((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem());
            }
            UISupport.showDesktopPanel(WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel);
        }
    }

    public class ShowStatisticsGraphAction
    extends AbstractAction {
        public ShowStatisticsGraphAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stats_graph.gif"));
            this.putValue("ShortDescription", "Shows the statistics graph");
        }

        public void actionPerformed(ActionEvent e) {
            if (WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel == null) {
                WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel = new StatisticsDesktopPanel((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem());
            }
            UISupport.showDesktopPanel(WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel);
        }
    }

    public class ResetAction
    extends AbstractAction {
        public ResetAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/reset_loadtest_statistics.gif"));
            this.putValue("ShortDescription", "Resets statistics for this LoadTest");
        }

        public void actionPerformed(ActionEvent e) {
            ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getStatisticsModel().reset();
        }
    }

    public class RunLoadTestAction
    extends AbstractAction {
        public RunLoadTestAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_testcase.gif"));
            this.putValue("ShortDescription", "Runs this LoadTest");
        }

        public void actionPerformed(ActionEvent e) {
            if (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTestCase().getTestStepCount() == 0) {
                UISupport.showErrorMessage("Missing TestSteps for testing!");
                return;
            }
            ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getStatisticsModel().reset();
            WsdlLoadTestDesktopPanel.this.loadTestLog.clear();
            WsdlLoadTestDesktopPanel.this.progressBar.setValue(0);
            WsdlLoadTestDesktopPanel.this.runner = (WsdlLoadTestRunner)((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).run();
            WsdlLoadTestDesktopPanel.this.runButton.setEnabled(false);
        }
    }

    private final class InternalDesktopListener
    extends DesktopListenerAdapter {
        private InternalDesktopListener() {
        }

        public void desktopPanelClosed(DesktopPanel desktopPanel) {
            if (desktopPanel == WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel) {
                WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel = null;
            } else if (desktopPanel == WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel) {
                WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel = null;
            }
        }
    }
}

