/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testsuite;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.testsuite.JTestCaseList;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.PropertiesMap;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.text.Document;

public class WsdlTestSuiteDesktopPanel
extends JPanel
implements DesktopPanel {
    private final WsdlTestSuite testSuite;
    private JProgressBar progressBar;
    private JTestCaseList testCaseList;
    private RunAction runAction = new RunAction();
    private CancelAction cancelAction = new CancelAction();
    private TestSuiteRunner testSuiteRunner = new TestSuiteRunner();
    private JToggleButton sequentialButton;
    private JToggleButton parallellButton;
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private JTextArea descriptionArea;

    public WsdlTestSuiteDesktopPanel(WsdlTestSuite testSuite) {
        super(new BorderLayout());
        this.testSuite = testSuite;
        this.buildUI();
        testSuite.addTestSuiteListener(this.testSuiteListener);
    }

    private void buildUI() {
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildContent(), "Center");
        this.setPreferredSize(new Dimension(300, 400));
    }

    public void addNotify() {
        super.addNotify();
        this.testSuite.addTestSuiteListener(this.testSuiteListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.testSuite.removeTestSuiteListener(this.testSuiteListener);
    }

    private JComponent buildToolbar() {
        this.cancelAction.setEnabled(false);
        this.runAction.setEnabled(this.testSuite.getTestCaseCount() > 0);
        JXToolBar toolbar = UISupport.createToolbar();
        ((Container)toolbar).add(UISupport.createToolbarButton(this.runAction));
        ((Container)toolbar).add(UISupport.createToolbarButton(this.cancelAction));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sequentialButton = new JToggleButton(UISupport.createImageIcon("/sequential.gif"), true);
        this.sequentialButton.setToolTipText("The selected TestCases are run in sequence");
        this.sequentialButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.sequentialButton.setSelected(this.testSuite.getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL);
        this.sequentialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WsdlTestSuiteDesktopPanel.this.testSuite.setRunType(TestSuite.TestSuiteRunType.SEQUENTIAL);
            }
        });
        buttonGroup.add(this.sequentialButton);
        this.parallellButton = new JToggleButton(UISupport.createImageIcon("/parallell.gif"));
        this.parallellButton.setToolTipText("The selected TestCases are run in parallel");
        this.parallellButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.parallellButton.setSelected(this.testSuite.getRunType() == TestSuite.TestSuiteRunType.PARALLEL);
        this.parallellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WsdlTestSuiteDesktopPanel.this.testSuite.setRunType(TestSuite.TestSuiteRunType.PARALLEL);
            }
        });
        buttonGroup.add(this.parallellButton);
        toolbar.addSeparator();
        ((Container)toolbar).add(this.sequentialButton);
        ((Container)toolbar).add(this.parallellButton);
        toolbar.addSeparator();
        ((Container)toolbar).add(Box.createHorizontalGlue());
        ((Container)toolbar).add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testsuites.html#TestSuite_Runner")));
        this.progressBar = new JProgressBar(0, this.testSuite.getTestCaseCount());
        JPanel progressPanel = UISupport.createProgressBarPanel(this.progressBar, 10, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolbar, "First");
        panel.add((Component)progressPanel, "Center");
        return panel;
    }

    private JComponent buildContent() {
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.addTab("TestCases", new JScrollPane(this.buildTestCaseList()));
        tabs.addTab("Description", this.buildDescriptionPanel());
        return UISupport.createTabPanel(tabs, true);
    }

    private Component buildDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.descriptionArea = new JTextArea(this.testSuite.getDescription());
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                WsdlTestSuiteDesktopPanel.this.testSuite.setDescription(WsdlTestSuiteDesktopPanel.this.descriptionArea.getText());
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        return panel;
    }

    private JComponent buildTestCaseList() {
        this.testCaseList = new JTestCaseList(this.testSuite);
        return new JScrollPane(this.testCaseList);
    }

    public Icon getIcon() {
        return this.getModelItem().getIcon();
    }

    public ModelItem getModelItem() {
        return this.testSuite;
    }

    public boolean onClose(boolean canCancel) {
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.testSuite || modelItem == this.testSuite.getProject();
    }

    public String getTitle() {
        return this.getModelItem().getName();
    }

    public String getDescription() {
        return "TestSuite: [" + this.getModelItem().getName() + "]";
    }

    public class TestSuiteRunner
    implements Runnable {
        private boolean canceled;
        private List<TestRunner> runners = new ArrayList<TestRunner>();
        private InternalTestRunListener internalTestRunListener = new InternalTestRunListener();

        public void cancel() {
            this.canceled = true;
            for (TestRunner runner : this.runners) {
                runner.cancel("Canceled from TestSuite");
            }
        }

        public void run() {
            this.canceled = false;
            WsdlTestSuiteDesktopPanel.this.runAction.setEnabled(false);
            WsdlTestSuiteDesktopPanel.this.cancelAction.setEnabled(true);
            WsdlTestSuiteDesktopPanel.this.testCaseList.setEnabled(false);
            int[] indices = WsdlTestSuiteDesktopPanel.this.testCaseList.getSelectedIndices();
            if (indices.length == 0) {
                indices = new int[WsdlTestSuiteDesktopPanel.this.testSuite.getTestCaseCount()];
                for (int c = 0; c < indices.length; ++c) {
                    indices[c] = c;
                }
            }
            WsdlTestSuiteDesktopPanel.this.progressBar.setValue(0);
            WsdlTestSuiteDesktopPanel.this.progressBar.setString("");
            WsdlTestSuiteDesktopPanel.this.progressBar.setMaximum(indices.length);
            TestSuite.TestSuiteRunType runType = WsdlTestSuiteDesktopPanel.this.testSuite.getRunType();
            for (int c = 0; c < indices.length; ++c) {
                WsdlTestCase testCase = WsdlTestSuiteDesktopPanel.this.testSuite.getTestCaseAt(indices[c]);
                if (SoapUI.getTestMonitor().hasRunningLoadTest(testCase)) {
                    WsdlTestSuiteDesktopPanel.this.progressBar.setString("Skipping " + testCase.getName());
                    WsdlTestSuiteDesktopPanel.this.progressBar.setValue(c + 1);
                    continue;
                }
                if (runType == TestSuite.TestSuiteRunType.PARALLEL) {
                    testCase.addTestRunListener(this.internalTestRunListener);
                    WsdlTestSuiteDesktopPanel.this.progressBar.setString("Starting " + testCase.getName());
                } else {
                    WsdlTestSuiteDesktopPanel.this.progressBar.setString("Running " + testCase.getName());
                }
                TestRunner runner = testCase.run(PropertiesMap.EMPTY_MAP, true);
                this.runners.add(runner);
                if (runType == TestSuite.TestSuiteRunType.SEQUENTIAL) {
                    runner.waitUntilFinished();
                    WsdlTestSuiteDesktopPanel.this.progressBar.setValue(c + 1);
                    this.runners.remove(runner);
                }
                if (this.canceled) break;
            }
            if (this.runners.isEmpty()) {
                this.finishRun();
            }
        }

        private void finishRun() {
            WsdlTestSuiteDesktopPanel.this.runAction.setEnabled(true);
            WsdlTestSuiteDesktopPanel.this.cancelAction.setEnabled(false);
            WsdlTestSuiteDesktopPanel.this.testCaseList.setEnabled(true);
        }

        private class InternalTestRunListener
        extends TestRunListenerAdapter {
            private InternalTestRunListener() {
            }

            public void afterRun(TestRunner testRunner, TestRunContext runContext) {
                TestSuiteRunner.this.runners.remove(testRunner);
                testRunner.getTestCase().removeTestRunListener(this);
                WsdlTestSuiteDesktopPanel.this.progressBar.setValue(WsdlTestSuiteDesktopPanel.this.progressBar.getValue() + 1);
                if (TestSuiteRunner.this.runners.isEmpty()) {
                    TestSuiteRunner.this.finishRun();
                }
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop_testcase.gif"));
            this.putValue("ShortDescription", "Cancels ongoing TestCase runs");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlTestSuiteDesktopPanel.this.testSuiteRunner.cancel();
        }
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_testcase.gif"));
            this.putValue("ShortDescription", "Runs the selected TestCases");
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(WsdlTestSuiteDesktopPanel.this.testSuiteRunner).start();
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testCaseAdded(TestCase testCase) {
            WsdlTestSuiteDesktopPanel.this.runAction.setEnabled(WsdlTestSuiteDesktopPanel.this.testSuite.getTestCaseCount() > 0);
        }

        public void testCaseRemoved(TestCase testCase) {
            WsdlTestSuiteDesktopPanel.this.runAction.setEnabled(WsdlTestSuiteDesktopPanel.this.testSuite.getTestCaseCount() > 0);
        }
    }
}

