/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.cipher;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class Square
extends Cipher
implements SymmetricCipher {
    private static final boolean \u00d5;
    private static final int \u00d0;
    private static final byte[] \u00cc;
    private static final byte[] \u00cd;
    private static final int[] \u00d4;
    private static final int[] \u00d6;
    private static final int \u00d3 = 16;
    private static final int \u00d1 = 8;
    private int[][] \u00d8 = new int[9][4];
    private static final int \u00d2 = 501;
    private static final int[] \u00cf;
    private static final String[][] \u00ce;

    private static void G(String string) {
        Debug.log("Square: " + string);
    }

    public Square() {
        super(false, false, "CryptixEDT");
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 16;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.A(key, true);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        this.A(key, false);
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 16;
        n3 = n5 * 16;
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            byArray = byArray3;
            n2 = 0;
        }
        if (bl) {
            for (int i2 = 0; i2 < n5; ++i2) {
                this.A(byArray, n2, byArray2, n4, \u00d4, \u00cc);
                n2 += 16;
                n4 += 16;
            }
        } else {
            for (int i3 = 0; i3 < n5; ++i3) {
                this.A(byArray, n2, byArray2, n4, \u00d6, \u00cd);
                n2 += 16;
                n4 += 16;
            }
        }
        return n3;
    }

    private void A(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        int n2 = 0;
        if (bl) {
            int n3;
            for (n3 = 0; n3 < 4; ++n3) {
                this.\u00d8[0][n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
            for (n3 = 1; n3 < 9; ++n3) {
                n2 = n3 - 1;
                this.\u00d8[n3][0] = this.\u00d8[n2][0] ^ Square.C(this.\u00d8[n2][3], 8) ^ \u00cf[n2];
                this.\u00d8[n3][1] = this.\u00d8[n2][1] ^ this.\u00d8[n3][0];
                this.\u00d8[n3][2] = this.\u00d8[n2][2] ^ this.\u00d8[n3][1];
                this.\u00d8[n3][3] = this.\u00d8[n2][3] ^ this.\u00d8[n3][2];
                Square.A(this.\u00d8[n2], this.\u00d8[n2]);
            }
        } else {
            int n4;
            int[][] nArray = new int[9][4];
            for (n4 = 0; n4 < 4; ++n4) {
                nArray[0][n4] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
            for (n4 = 1; n4 < 9; ++n4) {
                n2 = n4 - 1;
                nArray[n4][0] = nArray[n2][0] ^ Square.C(nArray[n2][3], 8) ^ \u00cf[n2];
                nArray[n4][1] = nArray[n2][1] ^ nArray[n4][0];
                nArray[n4][2] = nArray[n2][2] ^ nArray[n4][1];
                nArray[n4][3] = nArray[n2][3] ^ nArray[n4][2];
            }
            for (n4 = 0; n4 < 8; ++n4) {
                System.arraycopy(nArray[8 - n4], 0, this.\u00d8[n4], 0, 4);
            }
            Square.A(nArray[0], this.\u00d8[8]);
        }
    }

    private static void A(int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = nArray[i2];
            int n3 = n2 >>> 8;
            int n4 = n2 >>> 16;
            int n5 = n2 >>> 24;
            int n6 = ((Square.B(n5, 2) ^ Square.B(n4, 3) ^ n3 ^ n2) & 0xFF) << 24;
            n6 ^= ((n5 ^ Square.B(n4, 2) ^ Square.B(n3, 3) ^ n2) & 0xFF) << 16;
            n6 ^= ((n5 ^ n4 ^ Square.B(n3, 2) ^ Square.B(n2, 3)) & 0xFF) << 8;
            nArray2[i2] = n6 ^= (Square.B(n5, 3) ^ n4 ^ n3 ^ Square.B(n2, 2)) & 0xFF;
        }
    }

    private static int C(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private static int A(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    private static final int B(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        n2 &= 0xFF;
        n3 &= 0xFF;
        int n4 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                n4 ^= n2;
            }
            if ((n2 <<= 1) > 255) {
                n2 ^= 0x1F5;
            }
            n3 >>>= 1;
        }
        return n4 & 0xFF;
    }

    private void A(byte[] byArray, int n2, byte[] byArray2, int n3, int[] nArray, byte[] byArray3) {
        int n4;
        int n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n6 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n7 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n8 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        n5 ^= this.\u00d8[0][0];
        n6 ^= this.\u00d8[0][1];
        n7 ^= this.\u00d8[0][2];
        n8 ^= this.\u00d8[0][3];
        for (n4 = 1; n4 < 8; ++n4) {
            int n9 = nArray[n5 >>> 24 & 0xFF] ^ Square.A(nArray[n6 >>> 24 & 0xFF], 8) ^ Square.A(nArray[n7 >>> 24 & 0xFF], 16) ^ Square.A(nArray[n8 >>> 24 & 0xFF], 24) ^ this.\u00d8[n4][0];
            int n10 = nArray[n5 >>> 16 & 0xFF] ^ Square.A(nArray[n6 >>> 16 & 0xFF], 8) ^ Square.A(nArray[n7 >>> 16 & 0xFF], 16) ^ Square.A(nArray[n8 >>> 16 & 0xFF], 24) ^ this.\u00d8[n4][1];
            int n11 = nArray[n5 >>> 8 & 0xFF] ^ Square.A(nArray[n6 >>> 8 & 0xFF], 8) ^ Square.A(nArray[n7 >>> 8 & 0xFF], 16) ^ Square.A(nArray[n8 >>> 8 & 0xFF], 24) ^ this.\u00d8[n4][2];
            int n12 = nArray[n5 & 0xFF] ^ Square.A(nArray[n6 & 0xFF], 8) ^ Square.A(nArray[n7 & 0xFF], 16) ^ Square.A(nArray[n8 & 0xFF], 24) ^ this.\u00d8[n4][3];
            n5 = n9;
            n6 = n10;
            n7 = n11;
            n8 = n12;
        }
        n4 = 0;
        int n13 = 24;
        while (n4 < 4) {
            int n14 = (byArray3[n5 >>> n13 & 0xFF] & 0xFF) << 24 | (byArray3[n6 >>> n13 & 0xFF] & 0xFF) << 16 | (byArray3[n7 >>> n13 & 0xFF] & 0xFF) << 8 | byArray3[n8 >>> n13 & 0xFF] & 0xFF;
            byArray2[n3++] = (byte)((n14 ^= this.\u00d8[8][n4]) >>> 24 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 16 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 8 & 0xFF);
            byArray2[n3++] = (byte)(n14 & 0xFF);
            ++n4;
            n13 -= 8;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            Square.F();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void F() throws Exception {
        Cipher cipher = Cipher.getInstance("Square", "CryptixEDT");
        for (int i2 = 0; i2 < \u00ce.length; ++i2) {
            RawSecretKey rawSecretKey = new RawSecretKey("Square", Hex.fromString(\u00ce[i2][0]));
            byte[] byArray = Hex.fromString(\u00ce[i2][1]);
            byte[] byArray2 = Hex.fromString(\u00ce[i2][2]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray3 = cipher.crypt(byArray);
            if (!ArrayUtil.areEqual(byArray2, byArray3)) {
                System.out.println("     input: " + Hex.toString(byArray));
                System.out.println("  computed: " + Hex.toString(byArray3));
                System.out.println(" certified: " + Hex.toString(byArray2));
                throw new CryptixException("encrypt #" + i2 + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray3 = cipher.crypt(byArray2);
            if (ArrayUtil.areEqual(byArray, byArray3)) continue;
            throw new CryptixException("decrypt #" + i2 + " failed");
        }
        if (\u00d5 && \u00d0 > 0) {
            Square.G("Self-test OK");
        }
    }

    static {
        int n2;
        int n3;
        \u00d5 = Debug.GLOBAL_DEBUG;
        \u00d0 = \u00d5 ? Debug.getLevel("Square") : 0;
        \u00cc = new byte[256];
        \u00cd = new byte[256];
        \u00d4 = new int[256];
        \u00d6 = new int[256];
        \u00cf = new int[8];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byArray[0] = 1;
        for (n3 = 1; n3 < 256; ++n3) {
            n2 = byArray[n3 - 1] << 1;
            if ((n2 & 0x100) != 0) {
                n2 ^= 0x1F5;
            }
            byArray[n3] = (byte)n2;
            byArray2[n2 & 0xFF] = (byte)n3;
        }
        Square.\u00cc[0] = 0;
        Square.\u00cc[1] = 1;
        for (n3 = 2; n3 < 256; ++n3) {
            Square.\u00cc[n3] = byArray[255 - byArray2[n3] & 0xFF];
        }
        int[] nArray = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        for (n3 = 0; n3 < 256; ++n3) {
            int n4 = 177;
            for (n2 = 0; n2 < 8; ++n2) {
                int n5 = \u00cc[n3] & nArray[n2] & 0xFF;
                n5 ^= n5 >>> 4;
                n5 ^= n5 >>> 2;
                n5 ^= n5 >>> 1;
                n4 ^= (n5 &= 1) << n2;
            }
            Square.\u00cc[n3] = (byte)n4;
            Square.\u00cd[n4] = (byte)n3;
        }
        Square.\u00cf[0] = 1;
        for (n3 = 1; n3 < 8; ++n3) {
            Square.\u00cf[n3] = Square.B(\u00cf[n3 - 1], 2);
            int n6 = n3 - 1;
            \u00cf[n6] = \u00cf[n6] << 24;
        }
        \u00cf[7] = \u00cf[7] << 24;
        for (n3 = 0; n3 < 256; ++n3) {
            int n7 = \u00cc[n3] & 0xFF;
            int n8 = \u00cd[n3] & 0xFF;
            Square.\u00d4[n3] = \u00cc[n3 & 3] == 0 ? 0 : Square.B(n7, 2) << 24 | n7 << 16 | n7 << 8 | Square.B(n7, 3);
            Square.\u00d6[n3] = \u00cd[n3 & 3] == 0 ? 0 : Square.B(n8, 14) << 24 | Square.B(n8, 9) << 16 | Square.B(n8, 13) << 8 | Square.B(n8, 11);
        }
        \u00ce = new String[][]{{"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F"}, {"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F7C3491D94994E70F0EC2E7A5CCB5A14F"}};
    }
}

