/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.CryptixProperties;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalParams;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalPrivateKey;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalPublicKey;
import com.enterprisedt.cryptix.provider.elgamal.DefaultElGamalParameterSet;
import com.enterprisedt.cryptix.provider.elgamal.GenericElGamalParameterSet;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.math.Prime;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.interfaces.ElGamalKeyPairGenerator;
import xjava.security.interfaces.ElGamalParams;

public class BaseElGamalKeyPairGenerator
extends KeyPairGenerator
implements ElGamalKeyPairGenerator {
    private static final boolean H;
    private static final int C;
    private static final int F = 80;
    private static final boolean I = true;
    private static final boolean B = false;
    private static final int D = 1;
    private static final int G = 256;
    private static final BigInteger A;
    private static GenericElGamalParameterSet E;
    protected BigInteger p;
    protected BigInteger g;
    protected SecureRandom source;
    private static BigInteger[] J;

    private static void B(String string) {
        Debug.log("BaseElGamalKeyPairGenerator: " + string);
    }

    private static void A(String string) {
        Debug.log(string);
    }

    public BaseElGamalKeyPairGenerator() {
        super("ElGamal");
    }

    public void initialize(ElGamalParams elGamalParams, SecureRandom secureRandom) throws InvalidParameterException {
        this.initialize(elGamalParams.getP(), elGamalParams.getG(), secureRandom);
    }

    public void initialize(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) throws InvalidParameterException {
        if (bigInteger == null) {
            throw new NullPointerException("prime == null");
        }
        if (bigInteger2 == null) {
            throw new NullPointerException("base == null");
        }
        if (secureRandom == null) {
            throw new NullPointerException("random == null");
        }
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new InvalidParameterException("base >= prime");
        }
        this.p = bigInteger;
        this.g = bigInteger2;
        this.source = secureRandom;
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        ElGamalParams elGamalParams = null;
        if (E != null) {
            elGamalParams = E.getParameters(n2);
        }
        if (elGamalParams == null) {
            elGamalParams = this.generateParams(n2, secureRandom);
        }
        this.p = elGamalParams.getP();
        this.g = elGamalParams.getG();
        this.source = secureRandom;
    }

    public void initialize(int n2, boolean bl, SecureRandom secureRandom) throws InvalidParameterException {
        ElGamalParams elGamalParams;
        if (n2 < 256) {
            throw new InvalidParameterException("ElGamal: prime length " + n2 + " is too short (< " + 256 + ")");
        }
        if (bl || E == null) {
            elGamalParams = this.generateParams(n2, secureRandom);
        } else {
            elGamalParams = E.getParameters(n2);
            if (elGamalParams == null) {
                throw new InvalidParameterException("ElGamal: no pre-computed parameters for prime length " + n2);
            }
        }
        this.p = elGamalParams.getP();
        this.g = elGamalParams.getG();
        this.source = secureRandom;
    }

    public KeyPair generateKeyPair() {
        if (this.p == null) {
            throw new CryptixException("ElGamal: key pair generator not initialized");
        }
        int n2 = this.p.bitLength() - 1;
        BigInteger bigInteger = new BigInteger(n2, this.source).setBit(n2);
        BaseElGamalPrivateKey baseElGamalPrivateKey = new BaseElGamalPrivateKey(this.p, this.g, bigInteger);
        BaseElGamalPublicKey baseElGamalPublicKey = new BaseElGamalPublicKey(this.p, this.g, baseElGamalPrivateKey.getY());
        return new KeyPair(baseElGamalPublicKey, baseElGamalPrivateKey);
    }

    public ElGamalParams generateParams(int n2, SecureRandom secureRandom) throws InvalidParameterException {
        if (n2 < 256) {
            throw new InvalidParameterException("ElGamal: prime length " + n2 + " is too short (< " + 256 + ")");
        }
        Object[] objectArray = Prime.getElGamal(n2, 80, secureRandom, 1);
        BigInteger bigInteger = (BigInteger)objectArray[0];
        BigInteger[] bigIntegerArray = (BigInteger[])objectArray[1];
        BigInteger bigInteger2 = BaseElGamalKeyPairGenerator.A(bigInteger, bigIntegerArray, secureRandom);
        return new BaseElGamalParams(bigInteger, bigInteger2);
    }

    private static BigInteger A(BigInteger bigInteger, BigInteger[] bigIntegerArray, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        int n2;
        BigInteger bigInteger3 = bigInteger.subtract(A);
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
            bigIntegerArray2[n2] = bigInteger3.divide(bigIntegerArray[n2]);
        }
        if (H && C >= 5) {
            BaseElGamalKeyPairGenerator.A("g =");
        }
        n2 = bigInteger.bitLength() - 1;
        do {
            if (!H || C < 5) continue;
            BaseElGamalKeyPairGenerator.A(" ?");
        } while (!Prime.isGeneratorModP(bigInteger2 = new BigInteger(n2, secureRandom).setBit(n2), bigInteger, bigIntegerArray2));
        if (H && C >= 4) {
            BaseElGamalKeyPairGenerator.B(" OK");
        }
        return bigInteger2;
    }

    static {
        block4: {
            H = Debug.GLOBAL_DEBUG;
            C = H ? Debug.getLevel("ElGamal", "BaseElGamalKeyPairGenerator") : 0;
            A = BigInteger.valueOf(1L);
            try {
                String string = CryptixProperties.getProperty("Alg.DefaultParameterSet.ElGamal");
                if (string != null) {
                    E = (GenericElGamalParameterSet)Class.forName(string).newInstance();
                }
            }
            catch (Exception exception) {
                if (!H || C < 1) break block4;
                BaseElGamalKeyPairGenerator.B("exception while instantiating default parameter set: " + exception);
            }
        }
        if (E == null) {
            E = new DefaultElGamalParameterSet();
        }
    }
}

