/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalParams;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import xjava.security.interfaces.ElGamalParams;

public class GenericElGamalParameterSet {
    private int[] A;
    private String[][] B;

    protected GenericElGamalParameterSet(int[] nArray, String[][] stringArray) {
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        this.A = nArray;
        this.B = stringArray;
    }

    public ElGamalParams getParameters(int n2) {
        for (int i2 = 0; i2 < this.A.length; ++i2) {
            if (n2 != this.A[i2]) continue;
            return new BaseElGamalParams(new BigInteger(this.B[i2][0], 16), this.B[i2][1] != null ? new BigInteger(this.B[i2][1], 16) : null);
        }
        return null;
    }

    public void checkSane() throws InvalidParameterException {
        for (int i2 = 0; i2 < this.A.length; ++i2) {
            BigInteger bigInteger = new BigInteger(this.B[i2][0]);
            if (bigInteger.bitLength() < this.A[i2]) {
                throw new InvalidParameterException(bigInteger + " has incorrect bit length");
            }
            BigInteger bigInteger2 = new BigInteger(this.B[i2][1]);
            if (!bigInteger.isProbablePrime(80)) {
                throw new InvalidParameterException(bigInteger + " is not prime");
            }
            if (bigInteger2.compareTo(bigInteger) < 0) continue;
            throw new InvalidParameterException("g >= p");
        }
    }
}

