/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalKeyPairGenerator;
import com.enterprisedt.cryptix.provider.elgamal.ElGamalAlgorithm;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.Random;
import xjava.security.AsymmetricCipher;
import xjava.security.Cipher;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public class RawElGamalCipher
extends Cipher
implements AsymmetricCipher,
Cloneable {
    private static final int t = 1;
    private BigInteger s;
    private BigInteger q;
    private BigInteger o;
    private BigInteger u;
    private int r;
    private Random p;

    public RawElGamalCipher() {
        super(false, true, "CryptixEDT");
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        if (!(key instanceof ElGamalPublicKey)) {
            throw new InvalidKeyException("ElGamal: encryption key does not implement java.security.interfaces.ElGamalPublicKey");
        }
        ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)key;
        this.A(elGamalPublicKey.getP(), elGamalPublicKey.getG(), null, elGamalPublicKey.getY());
        if (this.p == null) {
            this.p = new SecureRandom();
        }
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        if (!(key instanceof ElGamalPrivateKey)) {
            throw new InvalidKeyException("ElGamal: decryption key does not implement java.security.interfaces.ElGamalPrivateKey");
        }
        ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)key;
        BigInteger bigInteger = elGamalPrivateKey.getX();
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getX() == null");
        }
        this.A(elGamalPrivateKey.getP(), elGamalPrivateKey.getG(), bigInteger, elGamalPrivateKey.getY());
    }

    private void A(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getP() == null");
        }
        if (bigInteger2 == null) {
            throw new InvalidKeyException("ElGamal: getG() == null");
        }
        if (bigInteger4 == null) {
            throw new InvalidKeyException("ElGamal: getY() == null");
        }
        this.s = bigInteger;
        this.q = bigInteger2;
        this.o = bigInteger3;
        this.u = bigInteger4;
        this.r = (this.s.bitLength() - 1) / 8;
    }

    protected int enginePlaintextBlockSize() {
        if (this.r == 0) {
            throw new CryptixException("ElGamal: plaintext block size is not valid until key is set");
        }
        return this.r;
    }

    protected int engineCiphertextBlockSize() {
        if (this.r == 0) {
            throw new CryptixException("ElGamal: ciphertext block size is not valid until key is set");
        }
        return this.r * 2;
    }

    protected void engineSetParameter(String string, Object object) {
        if (string.equals("random")) {
            if (!(object instanceof Random)) {
                throw new InvalidParameterException("value must be an instance of java.util.Random");
            }
            this.p = (Random)object;
            return;
        }
        throw new InvalidParameterException(string);
    }

    protected Object engineGetParameter(String string) {
        if (string.equals("random")) {
            return this.p;
        }
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (n3 <= 0) {
            return 0;
        }
        if (this.getState() == 1) {
            if (n3 != this.r) {
                throw new IllegalBlockSizeException("inLen = " + n3 + ", plaintext block size = " + this.r);
            }
            byte[] byArray3 = new byte[this.r];
            System.arraycopy(byArray, n2, byArray3, 0, this.r);
            BigInteger[] bigIntegerArray = new BigInteger[2];
            BigInteger bigInteger = new BigInteger(1, byArray3);
            ElGamalAlgorithm.encrypt(bigInteger, bigIntegerArray, this.s, this.q, this.u, this.p);
            byte[] byArray4 = bigIntegerArray[0].toByteArray();
            byte[] byArray5 = bigIntegerArray[1].toByteArray();
            ArrayUtil.clear(byArray2, n4, this.r * 2);
            System.arraycopy(byArray4, 0, byArray2, n4 + this.r - byArray4.length, byArray4.length);
            System.arraycopy(byArray5, 0, byArray2, n4 + this.r * 2 - byArray5.length, byArray5.length);
            ArrayUtil.clear(byArray3);
            return this.r * 2;
        }
        if (n3 != this.r * 2) {
            throw new IllegalBlockSizeException("inLen = " + n3 + ", ciphertext block size = " + this.r * 2);
        }
        byte[] byArray6 = new byte[this.r];
        System.arraycopy(byArray, n2, byArray6, 0, this.r);
        BigInteger bigInteger = new BigInteger(1, byArray6);
        System.arraycopy(byArray, n2 + this.r, byArray6, 0, this.r);
        BigInteger bigInteger2 = new BigInteger(1, byArray6);
        BigInteger bigInteger3 = ElGamalAlgorithm.decrypt(bigInteger, bigInteger2, this.s, this.q, this.o);
        byte[] byArray7 = bigInteger3.toByteArray();
        ArrayUtil.clear(byArray2, n4, this.r - byArray7.length);
        System.arraycopy(byArray7, 0, byArray2, n4 + this.r - byArray7.length, byArray7.length);
        return this.r;
    }

    public static final void main(String[] stringArray) {
        try {
            RawElGamalCipher.self_test(new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter printWriter) throws KeyException {
        BaseElGamalKeyPairGenerator baseElGamalKeyPairGenerator = new BaseElGamalKeyPairGenerator();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = System.currentTimeMillis();
        ((KeyPairGenerator)baseElGamalKeyPairGenerator).initialize(385, secureRandom);
        KeyPair keyPair = ((KeyPairGenerator)baseElGamalKeyPairGenerator).generateKeyPair();
        long l3 = System.currentTimeMillis() - l2;
        printWriter.println("Keygen: " + (float)l3 / 1000.0f + " seconds");
        RawElGamalCipher rawElGamalCipher = new RawElGamalCipher();
        rawElGamalCipher.A(printWriter, keyPair, secureRandom);
    }

    private void A(PrintWriter printWriter, KeyPair keyPair, SecureRandom secureRandom) throws KeyException {
        ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)keyPair.getPrivate();
        ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)keyPair.getPublic();
        BigInteger bigInteger = new BigInteger(elGamalPrivateKey.getP().bitLength() - 1, secureRandom);
        this.p = secureRandom;
        long l2 = System.currentTimeMillis();
        this.initEncrypt(elGamalPublicKey);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        ElGamalAlgorithm.encrypt(bigInteger, bigIntegerArray, this.s, this.q, this.u, this.p);
        long l3 = System.currentTimeMillis();
        this.initDecrypt(elGamalPrivateKey);
        BigInteger bigInteger2 = ElGamalAlgorithm.decrypt(bigIntegerArray[0], bigIntegerArray[1], this.s, this.q, this.o);
        long l4 = System.currentTimeMillis();
        printWriter.println("p = " + this.s);
        printWriter.println("g = " + this.q);
        printWriter.println("x = " + this.o);
        printWriter.println("y = " + this.u);
        printWriter.println("M = " + bigInteger);
        printWriter.println("a = " + bigIntegerArray[0]);
        printWriter.println("b = " + bigIntegerArray[1]);
        if (!bigInteger.equals(bigInteger2)) {
            printWriter.println("DECRYPTION FAILED!");
            printWriter.println("M' = " + bigInteger2);
        }
        printWriter.println("Encrypt: " + (float)(l3 - l2) / 1000.0f + " seconds");
        printWriter.println("Decrypt: " + (float)(l4 - l3) / 1000.0f + " seconds");
    }
}

