/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.Security;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.Parameterized;
import xjava.security.VariableLengthDigest;

public class HAVAL
extends MessageDigest
implements Parameterized,
VariableLengthDigest,
Cloneable {
    private static final int V = 1;
    private static final int P = 3;
    private static final int R = 256;
    private static final int U = 128;
    private static final int M = 8;
    private int T = 3;
    private int S = 256;
    private long Q;
    private int[] L = new int[8];
    private byte[] O = new byte[128];
    private int[] N = new int[32];

    public HAVAL() {
        super("HAVAL");
        int n2;
        String string;
        try {
            string = Security.getAlgorithmProperty("HAVAL", "passes");
            n2 = Integer.parseInt(string);
            if (n2 >= 3 && n2 <= 5) {
                this.T = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = Security.getAlgorithmProperty("HAVAL", "bitLength");
            n2 = Integer.parseInt(string);
            if (n2 % 32 == 0 && n2 >= 128 && n2 <= 256) {
                this.S = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.engineReset();
    }

    private HAVAL(HAVAL hAVAL) {
        this();
        this.T = hAVAL.T;
        this.S = hAVAL.S;
        this.Q = hAVAL.Q;
        this.L = (int[])hAVAL.L.clone();
        this.O = (byte[])hAVAL.O.clone();
    }

    public Object clone() {
        return new HAVAL(this);
    }

    protected void engineReset() {
        this.L[0] = 608135816;
        this.L[1] = -2052912941;
        this.L[2] = 320440878;
        this.L[3] = 57701188;
        this.L[4] = -1542899678;
        this.L[5] = 698298832;
        this.L[6] = 137296536;
        this.L[7] = -330404727;
        this.Q = 0L;
        for (int i2 = 0; i2 < 128; ++i2) {
            this.O[i2] = 0;
        }
    }

    protected void engineUpdate(byte by) {
        int n2 = (int)(this.Q % 128L);
        ++this.Q;
        this.O[n2] = by;
        if (n2 == 127) {
            this.A(this.O, 0);
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || (long)n2 + (long)n3 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = (int)(this.Q % 128L);
        this.Q += (long)n3;
        int n5 = 128 - n4;
        int n6 = 0;
        if (n3 >= n5) {
            System.arraycopy(byArray, n2, this.O, n4, n5);
            this.A(this.O, 0);
            n6 = n5;
            while (n6 + 128 - 1 < n3) {
                this.A(byArray, n2 + n6);
                n6 += 128;
            }
            n4 = 0;
        }
        if (n6 < n3) {
            System.arraycopy(byArray, n2 + n6, this.O, n4, n3 - n6);
        }
    }

    protected byte[] engineDigest() {
        int n2 = (int)(this.Q % 128L);
        int n3 = n2 < 118 ? 118 - n2 : 246 - n2;
        byte[] byArray = new byte[n3 + 10];
        byArray[0] = 1;
        byArray[n3] = (byte)((this.S & 3) << 6 | (this.T & 7) << 3 | 1);
        byArray[n3 + 1] = (byte)(this.S >>> 2);
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[n3 + 2 + i2] = (byte)(this.Q * 8L >>> 8 * i2);
        }
        this.engineUpdate(byArray, 0, byArray.length);
        this.C();
        byte[] byArray2 = new byte[this.S / 8];
        for (int i3 = 0; i3 < this.S / 32; ++i3) {
            for (int i4 = 0; i4 < 4; ++i4) {
                byArray2[i3 * 4 + i4] = (byte)(this.L[i3] >>> 8 * i4);
            }
        }
        this.engineReset();
        return byArray2;
    }

    protected int engineGetDigestLength() {
        return this.S / 8;
    }

    public void setParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        this.engineSetParameter(string, object);
    }

    public Object getParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        return this.engineGetParameter(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string.equalsIgnoreCase("passes")) {
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("passes.HAVAL");
            this.setPasses((Integer)object);
            return;
        } else {
            if (!string.equalsIgnoreCase("bitLength")) throw new NoSuchParameterException(string + ".HAVAL");
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("bitLength.HAVAL");
            this.setBitLength((Integer)object);
        }
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string.equalsIgnoreCase("passes")) {
            return new Integer(this.T);
        }
        if (string.equalsIgnoreCase("bitLength")) {
            return new Integer(this.S);
        }
        throw new NoSuchParameterException(string + ".HAVAL");
    }

    public void setPasses(int n2) {
        if (n2 < 3 || n2 > 5) {
            throw new InvalidParameterException();
        }
        this.T = n2;
        this.engineReset();
    }

    public void setBitLength(int n2) {
        if (n2 % 32 != 0 || n2 < 128 || n2 > 256) {
            throw new InvalidParameterException();
        }
        this.S = n2;
        this.engineReset();
    }

    public void setDigestLength(int n2) {
        this.setBitLength(n2 * 8);
    }

    private void A(byte[] byArray, int n2) {
        int n3;
        for (n3 = 0; n3 < 32; ++n3) {
            this.N[n3] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        }
        n3 = this.L[0];
        int n4 = this.L[1];
        int n5 = this.L[2];
        int n6 = this.L[3];
        int n7 = this.L[4];
        int n8 = this.L[5];
        int n9 = this.L[6];
        int n10 = this.L[7];
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[0]);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[1]);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[2]);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[3]);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[4]);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[5]);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[6]);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[7]);
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[8]);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[9]);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[10]);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[11]);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[12]);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[13]);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[14]);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[15]);
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[16]);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[17]);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[18]);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[19]);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[20]);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[21]);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[22]);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[23]);
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[24]);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[25]);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[26]);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[27]);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[28]);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[29]);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[30]);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[31]);
        n10 = this.C(n10, n9, n8, n7, n6, n5, n4, n3, this.N[5], 1160258022);
        n9 = this.C(n9, n8, n7, n6, n5, n4, n3, n10, this.N[14], 953160567);
        n8 = this.C(n8, n7, n6, n5, n4, n3, n10, n9, this.N[26], -1101764913);
        n7 = this.C(n7, n6, n5, n4, n3, n10, n9, n8, this.N[18], 887688300);
        n6 = this.C(n6, n5, n4, n3, n10, n9, n8, n7, this.N[11], -1062458953);
        n5 = this.C(n5, n4, n3, n10, n9, n8, n7, n6, this.N[28], -914599715);
        n4 = this.C(n4, n3, n10, n9, n8, n7, n6, n5, this.N[7], 1065670069);
        n3 = this.C(n3, n10, n9, n8, n7, n6, n5, n4, this.N[16], -1253635817);
        n10 = this.C(n10, n9, n8, n7, n6, n5, n4, n3, this.N[0], -1843997223);
        n9 = this.C(n9, n8, n7, n6, n5, n4, n3, n10, this.N[23], -1988494565);
        n8 = this.C(n8, n7, n6, n5, n4, n3, n10, n9, this.N[20], -785314906);
        n7 = this.C(n7, n6, n5, n4, n3, n10, n9, n8, this.N[22], -1730169428);
        n6 = this.C(n6, n5, n4, n3, n10, n9, n8, n7, this.N[1], 805139163);
        n5 = this.C(n5, n4, n3, n10, n9, n8, n7, n6, this.N[10], -803545161);
        n4 = this.C(n4, n3, n10, n9, n8, n7, n6, n5, this.N[4], -1193168915);
        n3 = this.C(n3, n10, n9, n8, n7, n6, n5, n4, this.N[8], 1780907670);
        n10 = this.C(n10, n9, n8, n7, n6, n5, n4, n3, this.N[30], -1166241723);
        n9 = this.C(n9, n8, n7, n6, n5, n4, n3, n10, this.N[3], -248741991);
        n8 = this.C(n8, n7, n6, n5, n4, n3, n10, n9, this.N[21], 614570311);
        n7 = this.C(n7, n6, n5, n4, n3, n10, n9, n8, this.N[9], -1282315017);
        n6 = this.C(n6, n5, n4, n3, n10, n9, n8, n7, this.N[17], 134345442);
        n5 = this.C(n5, n4, n3, n10, n9, n8, n7, n6, this.N[24], -2054226922);
        n4 = this.C(n4, n3, n10, n9, n8, n7, n6, n5, this.N[29], 1667834072);
        n3 = this.C(n3, n10, n9, n8, n7, n6, n5, n4, this.N[6], 1901547113);
        n10 = this.C(n10, n9, n8, n7, n6, n5, n4, n3, this.N[19], -1537671517);
        n9 = this.C(n9, n8, n7, n6, n5, n4, n3, n10, this.N[12], -191677058);
        n8 = this.C(n8, n7, n6, n5, n4, n3, n10, n9, this.N[15], 227898511);
        n7 = this.C(n7, n6, n5, n4, n3, n10, n9, n8, this.N[13], 1921955416);
        n6 = this.C(n6, n5, n4, n3, n10, n9, n8, n7, this.N[2], 1904987480);
        n5 = this.C(n5, n4, n3, n10, n9, n8, n7, n6, this.N[25], -2112533778);
        n4 = this.C(n4, n3, n10, n9, n8, n7, n6, n5, this.N[31], 2069144605);
        n3 = this.C(n3, n10, n9, n8, n7, n6, n5, n4, this.N[27], -1034266187);
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[19], -1674521287);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[9], 720527379);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[4], -976113629);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[20], 677414384);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[28], -901678824);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[17], -1193592593);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[8], -1904616272);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[22], 1614419982);
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[29], 1822297739);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[14], -1340175810);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[25], -686458943);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[12], -1120842969);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[24], 2024746970);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[30], 1432378464);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[16], -430627341);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[26], -1437226092);
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[31], 1464375394);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[15], 1676153920);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[7], 1439316330);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[3], 715854006);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[1], -1261675468);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[0], 289532110);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[18], -1588296017);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[27], 2087905683);
        n10 = this.A(n10, n9, n8, n7, n6, n5, n4, n3, this.N[13], -1276242927);
        n9 = this.A(n9, n8, n7, n6, n5, n4, n3, n10, this.N[6], 1668267050);
        n8 = this.A(n8, n7, n6, n5, n4, n3, n10, n9, this.N[21], 732546397);
        n7 = this.A(n7, n6, n5, n4, n3, n10, n9, n8, this.N[10], 1947742710);
        n6 = this.A(n6, n5, n4, n3, n10, n9, n8, n7, this.N[23], -832815594);
        n5 = this.A(n5, n4, n3, n10, n9, n8, n7, n6, this.N[11], -1685613794);
        n4 = this.A(n4, n3, n10, n9, n8, n7, n6, n5, this.N[5], -1344882125);
        n3 = this.A(n3, n10, n9, n8, n7, n6, n5, n4, this.N[2], 1814351708);
        if (this.T >= 4) {
            n10 = this.B(n10, n9, n8, n7, n6, n5, n4, n3, this.N[24], 2050118529);
            n9 = this.B(n9, n8, n7, n6, n5, n4, n3, n10, this.N[4], 680887927);
            n8 = this.B(n8, n7, n6, n5, n4, n3, n10, n9, this.N[0], 999245976);
            n7 = this.B(n7, n6, n5, n4, n3, n10, n9, n8, this.N[14], 1800124847);
            n6 = this.B(n6, n5, n4, n3, n10, n9, n8, n7, this.N[2], -994056165);
            n5 = this.B(n5, n4, n3, n10, n9, n8, n7, n6, this.N[7], 1713906067);
            n4 = this.B(n4, n3, n10, n9, n8, n7, n6, n5, this.N[28], 1641548236);
            n3 = this.B(n3, n10, n9, n8, n7, n6, n5, n4, this.N[23], -81679983);
            n10 = this.B(n10, n9, n8, n7, n6, n5, n4, n3, this.N[26], 1216130144);
            n9 = this.B(n9, n8, n7, n6, n5, n4, n3, n10, this.N[6], 1575780402);
            n8 = this.B(n8, n7, n6, n5, n4, n3, n10, n9, this.N[30], -276538019);
            n7 = this.B(n7, n6, n5, n4, n3, n10, n9, n8, this.N[20], -377129551);
            n6 = this.B(n6, n5, n4, n3, n10, n9, n8, n7, this.N[18], -601480446);
            n5 = this.B(n5, n4, n3, n10, n9, n8, n7, n6, this.N[25], -345695352);
            n4 = this.B(n4, n3, n10, n9, n8, n7, n6, n5, this.N[19], 596196993);
            n3 = this.B(n3, n10, n9, n8, n7, n6, n5, n4, this.N[3], -745100091);
            n10 = this.B(n10, n9, n8, n7, n6, n5, n4, n3, this.N[22], 258830323);
            n9 = this.B(n9, n8, n7, n6, n5, n4, n3, n10, this.N[11], -2081144263);
            n8 = this.B(n8, n7, n6, n5, n4, n3, n10, n9, this.N[31], 772490370);
            n7 = this.B(n7, n6, n5, n4, n3, n10, n9, n8, this.N[21], -1534844924);
            n6 = this.B(n6, n5, n4, n3, n10, n9, n8, n7, this.N[8], 1774776394);
            n5 = this.B(n5, n4, n3, n10, n9, n8, n7, n6, this.N[27], -1642095778);
            n4 = this.B(n4, n3, n10, n9, n8, n7, n6, n5, this.N[12], 566650946);
            n3 = this.B(n3, n10, n9, n8, n7, n6, n5, n4, this.N[9], -152474470);
            n10 = this.B(n10, n9, n8, n7, n6, n5, n4, n3, this.N[1], 1728879713);
            n9 = this.B(n9, n8, n7, n6, n5, n4, n3, n10, this.N[29], -1412200208);
            n8 = this.B(n8, n7, n6, n5, n4, n3, n10, n9, this.N[5], 1783734482);
            n7 = this.B(n7, n6, n5, n4, n3, n10, n9, n8, this.N[15], -665571480);
            n6 = this.B(n6, n5, n4, n3, n10, n9, n8, n7, this.N[17], -1777359064);
            n5 = this.B(n5, n4, n3, n10, n9, n8, n7, n6, this.N[10], -1420741725);
            n4 = this.B(n4, n3, n10, n9, n8, n7, n6, n5, this.N[16], 1861159788);
            n3 = this.B(n3, n10, n9, n8, n7, n6, n5, n4, this.N[13], 326777828);
        }
        if (this.T == 5) {
            n10 = this.D(n10, n9, n8, n7, n6, n5, n4, n3, this.N[27], -1170476976);
            n9 = this.D(n9, n8, n7, n6, n5, n4, n3, n10, this.N[3], 2130389656);
            n8 = this.D(n8, n7, n6, n5, n4, n3, n10, n9, this.N[21], -1578015459);
            n7 = this.D(n7, n6, n5, n4, n3, n10, n9, n8, this.N[26], 967770486);
            n6 = this.D(n6, n5, n4, n3, n10, n9, n8, n7, this.N[17], 1724537150);
            n5 = this.D(n5, n4, n3, n10, n9, n8, n7, n6, this.N[11], -2109534584);
            n4 = this.D(n4, n3, n10, n9, n8, n7, n6, n5, this.N[20], -1930525159);
            n3 = this.D(n3, n10, n9, n8, n7, n6, n5, n4, this.N[29], 1164943284);
            n10 = this.D(n10, n9, n8, n7, n6, n5, n4, n3, this.N[19], 2105845187);
            n9 = this.D(n9, n8, n7, n6, n5, n4, n3, n10, this.N[0], 998989502);
            n8 = this.D(n8, n7, n6, n5, n4, n3, n10, n9, this.N[12], -529566248);
            n7 = this.D(n7, n6, n5, n4, n3, n10, n9, n8, this.N[7], -2050940813);
            n6 = this.D(n6, n5, n4, n3, n10, n9, n8, n7, this.N[13], 1075463327);
            n5 = this.D(n5, n4, n3, n10, n9, n8, n7, n6, this.N[8], 1455516326);
            n4 = this.D(n4, n3, n10, n9, n8, n7, n6, n5, this.N[31], 1322494562);
            n3 = this.D(n3, n10, n9, n8, n7, n6, n5, n4, this.N[10], 910128902);
            n10 = this.D(n10, n9, n8, n7, n6, n5, n4, n3, this.N[5], 469688178);
            n9 = this.D(n9, n8, n7, n6, n5, n4, n3, n10, this.N[9], 1117454909);
            n8 = this.D(n8, n7, n6, n5, n4, n3, n10, n9, this.N[14], 936433444);
            n7 = this.D(n7, n6, n5, n4, n3, n10, n9, n8, this.N[30], -804646328);
            n6 = this.D(n6, n5, n4, n3, n10, n9, n8, n7, this.N[18], -619713837);
            n5 = this.D(n5, n4, n3, n10, n9, n8, n7, n6, this.N[6], 1240580251);
            n4 = this.D(n4, n3, n10, n9, n8, n7, n6, n5, this.N[28], 122909385);
            n3 = this.D(n3, n10, n9, n8, n7, n6, n5, n4, this.N[24], -2137449605);
            n10 = this.D(n10, n9, n8, n7, n6, n5, n4, n3, this.N[2], 634681816);
            n9 = this.D(n9, n8, n7, n6, n5, n4, n3, n10, this.N[23], -152510729);
            n8 = this.D(n8, n7, n6, n5, n4, n3, n10, n9, this.N[16], -469872614);
            n7 = this.D(n7, n6, n5, n4, n3, n10, n9, n8, this.N[22], -1233564613);
            n6 = this.D(n6, n5, n4, n3, n10, n9, n8, n7, this.N[4], -1754472259);
            n5 = this.D(n5, n4, n3, n10, n9, n8, n7, n6, this.N[1], 79693498);
            n4 = this.D(n4, n3, n10, n9, n8, n7, n6, n5, this.N[25], -1045868618);
            n3 = this.D(n3, n10, n9, n8, n7, n6, n5, n4, this.N[15], 1084186820);
        }
        this.L[0] = this.L[0] + n3;
        this.L[1] = this.L[1] + n4;
        this.L[2] = this.L[2] + n5;
        this.L[3] = this.L[3] + n6;
        this.L[4] = this.L[4] + n7;
        this.L[5] = this.L[5] + n8;
        this.L[6] = this.L[6] + n9;
        this.L[7] = this.L[7] + n10;
    }

    private void C() {
        if (this.S == 128) {
            int n2 = this.L[7] & 0xFF | this.L[6] & 0xFF000000 | this.L[5] & 0xFF0000 | this.L[4] & 0xFF00;
            this.L[0] = this.L[0] + (n2 >>> 8 | n2 << 24);
            n2 = this.L[7] & 0xFF00 | this.L[6] & 0xFF | this.L[5] & 0xFF000000 | this.L[4] & 0xFF0000;
            this.L[1] = this.L[1] + (n2 >>> 16 | n2 << 16);
            n2 = this.L[7] & 0xFF0000 | this.L[6] & 0xFF00 | this.L[5] & 0xFF | this.L[4] & 0xFF000000;
            this.L[2] = this.L[2] + (n2 >>> 24 | n2 << 8);
            n2 = this.L[7] & 0xFF000000 | this.L[6] & 0xFF0000 | this.L[5] & 0xFF00 | this.L[4] & 0xFF;
            this.L[3] = this.L[3] + n2;
        } else if (this.S == 160) {
            int n3 = this.L[7] & 0x3F | this.L[6] & 0xFE000000 | this.L[5] & 0x1F80000;
            this.L[0] = this.L[0] + (n3 >>> 19 | n3 << 13);
            n3 = this.L[7] & 0xFC0 | this.L[6] & 0x3F | this.L[5] & 0xFE000000;
            this.L[1] = this.L[1] + (n3 >>> 25 | n3 << 7);
            n3 = this.L[7] & 0x7F000 | this.L[6] & 0xFC0 | this.L[5] & 0x3F;
            this.L[2] = this.L[2] + n3;
            n3 = this.L[7] & 0x1F80000 | this.L[6] & 0x7F000 | this.L[5] & 0xFC0;
            this.L[3] = this.L[3] + (n3 >>> 6);
            n3 = this.L[7] & 0xFE000000 | this.L[6] & 0x1F80000 | this.L[5] & 0x7F000;
            this.L[4] = this.L[4] + (n3 >>> 12);
        } else if (this.S == 192) {
            int n4 = this.L[7] & 0x1F | this.L[6] & 0xFC000000;
            this.L[0] = this.L[0] + (n4 >>> 26 | n4 << 6);
            n4 = this.L[7] & 0x3E0 | this.L[6] & 0x1F;
            this.L[1] = this.L[1] + n4;
            n4 = this.L[7] & 0xFC00 | this.L[6] & 0x3E0;
            this.L[2] = this.L[2] + (n4 >>> 5);
            n4 = this.L[7] & 0x1F0000 | this.L[6] & 0xFC00;
            this.L[3] = this.L[3] + (n4 >>> 10);
            n4 = this.L[7] & 0x3E00000 | this.L[6] & 0x1F0000;
            this.L[4] = this.L[4] + (n4 >>> 16);
            n4 = this.L[7] & 0xFC000000 | this.L[6] & 0x3E00000;
            this.L[5] = this.L[5] + (n4 >>> 21);
        } else if (this.S == 224) {
            this.L[0] = this.L[0] + (this.L[7] >>> 27 & 0x1F);
            this.L[1] = this.L[1] + (this.L[7] >>> 22 & 0x1F);
            this.L[2] = this.L[2] + (this.L[7] >>> 18 & 0xF);
            this.L[3] = this.L[3] + (this.L[7] >>> 13 & 0x1F);
            this.L[4] = this.L[4] + (this.L[7] >>> 9 & 0xF);
            this.L[5] = this.L[5] + (this.L[7] >>> 4 & 0x1F);
            this.L[6] = this.L[6] + (this.L[7] & 0xF);
        }
    }

    private int A(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.T) {
            case 3: {
                n11 = this.C(n8, n9, n6, n4, n3, n7, n5);
                break;
            }
            case 4: {
                n11 = this.C(n7, n3, n8, n5, n4, n6, n9);
                break;
            }
            default: {
                n11 = this.C(n6, n5, n8, n9, n4, n7, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n2 >>> 11 | n2 << 21) + n10;
    }

    private int C(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        switch (this.T) {
            case 3: {
                n12 = this.D(n5, n7, n8, n9, n4, n6, n3);
                break;
            }
            case 4: {
                n12 = this.D(n6, n4, n7, n9, n8, n3, n5);
                break;
            }
            default: {
                n12 = this.D(n3, n7, n8, n9, n6, n5, n4);
            }
        }
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int A(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        switch (this.T) {
            case 3: {
                n12 = this.E(n3, n8, n7, n6, n5, n4, n9);
                break;
            }
            case 4: {
                n12 = this.E(n8, n5, n6, n3, n9, n7, n4);
                break;
            }
            default: {
                n12 = this.E(n7, n3, n9, n5, n6, n8, n4);
            }
        }
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int B(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        switch (this.T) {
            case 4: {
                n12 = this.A(n3, n5, n9, n4, n7, n8, n6);
                break;
            }
            default: {
                n12 = this.A(n8, n4, n6, n7, n9, n5, n3);
            }
        }
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12 = this.B(n7, n4, n9, n3, n5, n6, n8);
        return (n12 >>> 7 | n12 << 25) + (n2 >>> 11 | n2 << 21) + n10 + n11;
    }

    private int C(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n7 & (n8 ^ n4) ^ n6 & n3 ^ n5 & n2 ^ n8;
    }

    private int D(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n6 & (n7 & ~n5 ^ n4 & n3 ^ n2 ^ n8) ^ n4 & (n7 ^ n3) ^ n5 & n3 ^ n8;
    }

    private int E(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n5 & (n7 & n6 ^ n2 ^ n8) ^ n7 & n4 ^ n6 & n3 ^ n8;
    }

    private int A(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n4 & (n3 & ~n6 ^ n5 & ~n2 ^ n7 ^ n2 ^ n8) ^ n5 & (n7 & n6 ^ n3 ^ n2) ^ n6 & n2 ^ n8;
    }

    private int B(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n8 & (n7 & n6 & n5 ^ ~n3) ^ n7 & n4 ^ n6 & n3 ^ n5 & n2;
    }
}

