/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.provider.rsa.RSAAlgorithm;
import com.enterprisedt.cryptix.provider.rsa.RawRSAPrivateKey;
import com.enterprisedt.cryptix.provider.rsa.RawRSAPublicKey;
import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Debug;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.interfaces.RSAKeyPairGenerator;

public class BaseRSAKeyPairGenerator
extends KeyPairGenerator
implements RSAKeyPairGenerator {
    private static final boolean H = Debug.GLOBAL_DEBUG;
    private static final int E = H ? Debug.getLevel("RSA", "BaseRSAKeyPairGenerator") : 0;
    private int C;
    private BigInteger F;
    private SecureRandom A;
    private static final int G = 80;
    private static final BigInteger D = BigInteger.valueOf(65537L);
    private static final BigInteger B = BigInteger.valueOf(1L);
    private static final int I = 1024;

    private static void A(String string) {
        Debug.log("BaseRSAKeyPairGenerator: " + string);
    }

    public BaseRSAKeyPairGenerator() {
        super("RSA");
    }

    public void initialize(int n2, BigInteger bigInteger, SecureRandom secureRandom) {
        this.F = bigInteger == null ? D : bigInteger;
        this.C = n2 < 2 ? 1024 : n2;
        this.A = secureRandom == null ? new SecureRandom() : secureRandom;
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.initialize(n2, D, secureRandom);
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        int n2 = this.C / 2;
        int n3 = this.C - n2;
        long l2 = 0L;
        if (H && E >= 7) {
            l2 = System.currentTimeMillis();
        }
        while (true) {
            try {
                do {
                    bigInteger4 = new BigInteger(n2, 80, this.A);
                    bigInteger3 = new BigInteger(n3, 80, this.A);
                    bigInteger2 = bigInteger4.multiply(bigInteger3);
                } while (bigInteger4.compareTo(bigInteger3) == 0 || bigInteger2.bitLength() != this.C);
                BigInteger bigInteger5 = bigInteger4.subtract(B).multiply(bigInteger3.subtract(B));
                bigInteger = this.F.modInverse(bigInteger5);
            }
            catch (ArithmeticException arithmeticException) {
                continue;
            }
            break;
        }
        if (H && E >= 7) {
            l2 = System.currentTimeMillis() - l2;
            BaseRSAKeyPairGenerator.A(" ...generateKeyPair() completed in " + l2 + " ms.");
        }
        if (H && E >= 5) {
            try {
                BaseRSAKeyPairGenerator.A("RSA parameters self test #1/2... ");
                BigInteger bigInteger6 = new BigInteger(n2, this.A);
                BigInteger bigInteger7 = RSAAlgorithm.rsa(bigInteger6, bigInteger2, this.F);
                BigInteger bigInteger8 = RSAAlgorithm.rsa(bigInteger7, bigInteger2, bigInteger);
                boolean bl = bigInteger8.compareTo(bigInteger6) == 0;
                BaseRSAKeyPairGenerator.A(bl ? "OK" : "Failed");
                if (!bl) {
                    throw new RuntimeException();
                }
                BaseRSAKeyPairGenerator.A("RSA parameters self test #2/2... ");
                BigInteger bigInteger9 = bigInteger3.modInverse(bigInteger4);
                bigInteger8 = RSAAlgorithm.rsa(bigInteger7, bigInteger2, bigInteger, bigInteger4, bigInteger3, bigInteger9);
                bl = bigInteger8.compareTo(bigInteger6) == 0;
                BaseRSAKeyPairGenerator.A(bl ? "OK" : "Failed");
                if (!bl) {
                    throw new RuntimeException();
                }
            }
            catch (Exception exception) {
                BaseRSAKeyPairGenerator.A("RSA parameters:");
                BaseRSAKeyPairGenerator.A("         n: " + BI.dumpString(bigInteger2));
                BaseRSAKeyPairGenerator.A("         e: " + BI.dumpString(this.F));
                BaseRSAKeyPairGenerator.A("         d: " + BI.dumpString(bigInteger));
                BaseRSAKeyPairGenerator.A("         p: " + BI.dumpString(bigInteger4));
                BaseRSAKeyPairGenerator.A("         q: " + BI.dumpString(bigInteger3));
                BaseRSAKeyPairGenerator.A("q^-1 mod p: " + BI.dumpString(bigInteger3.modInverse(bigInteger4)));
                throw new RuntimeException(this.F.toString());
            }
        }
        return this.makeKeyPair(bigInteger2, this.F, bigInteger, bigInteger4, bigInteger3);
    }

    protected KeyPair makeKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        RawRSAPublicKey rawRSAPublicKey = new RawRSAPublicKey(bigInteger, bigInteger2);
        RawRSAPrivateKey rawRSAPrivateKey = new RawRSAPrivateKey(bigInteger3, bigInteger4, bigInteger5);
        return new KeyPair(rawRSAPublicKey, rawRSAPrivateKey);
    }

    public void initialize() {
        this.initialize(1024, D, new SecureRandom());
    }
}

