/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.provider.rsa.BaseRSAPrivateKey;
import com.enterprisedt.cryptix.util.core.BI;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class RawRSAPrivateKey
extends BaseRSAPrivateKey {
    public RawRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setRsaParams(bigInteger, bigInteger2);
    }

    public RawRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, null);
    }

    public RawRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public RawRSAPrivateKey(InputStream inputStream) throws IOException {
        BigInteger bigInteger = BI.fromStream(inputStream);
        BigInteger bigInteger2 = BI.fromStream(inputStream);
        BigInteger bigInteger3 = BI.fromStream(inputStream);
        BigInteger bigInteger4 = BI.fromStream(inputStream);
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        try {
            BI.toStream(this.getExponent(), bufferedOutputStream);
            BI.toStream(this.getP(), bufferedOutputStream);
            BI.toStream(this.getQ(), bufferedOutputStream);
            BI.toStream(this.getInverseOfQModP(), bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

