/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.tools;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.StringTokenizer;
import xjava.security.Cipher;
import xjava.security.SecretKey;

public final class MCT {
    static final String U = "$Revision: 1.2 $";
    static final String E = "<as stated on the submission cover sheet>";
    boolean L = false;
    boolean A = false;
    String K = null;
    String M = null;
    String X = null;
    String R = null;
    File S = null;
    int[] N = new int[]{128, 192, 256};
    final String H = "ecb_e_m.txt";
    final String V = "ecb_d_m.txt";
    final String O = "cbc_e_m.txt";
    final String D = "cbc_d_m.txt";
    long W;
    long J;
    long I;
    Class T = null;
    Method G = null;
    Method Q = null;
    Method P = null;
    Method C = null;
    Cipher B = null;
    boolean F = true;

    public static void main(String[] stringArray) {
        System.out.println("NIST Monte-Carlo Tests data generator/exerciser\n\n$Revision: 1.2 $\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        MCT mCT = new MCT();
        mCT.A(stringArray);
        mCT.B();
    }

    void A(String[] stringArray) {
        int n2 = stringArray.length;
        if (n2 == 0) {
            this.A();
        }
        System.out.println("(type \"java cryptix.tools.MCT\" with no arguments for help)\n\n");
        int n3 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n3 >= n2) break;
                string = stringArray[n3];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-e")) {
                this.L = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-c")) {
                this.A = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-l")) {
                this.M = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.K = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            if (string.startsWith("-p")) {
                this.X = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            this.R = string;
        }
        if (this.R == null) {
            MCT.B("Missing cipher algorithm name");
        }
        if (this.R.length() > 1 && (this.R.startsWith("\"") || this.R.startsWith("'"))) {
            this.R = this.R.substring(2, this.R.length() - 2);
        }
        if (this.X == null) {
            this.X = this.R;
        }
        if (this.M != null) {
            int n4 = 0;
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(this.M, ", \t\"");
            while (stringTokenizer.hasMoreTokens()) {
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                if (n5 <= 0) {
                    MCT.B("Negative key length not allowed: " + n5);
                }
                if (n4 == 3) {
                    MCT.B("Only three key-length values are allowed.");
                }
                nArray[n4++] = n5;
            }
            if (n4 != 0) {
                this.N = new int[n4];
                System.arraycopy(nArray, 0, this.N, 0, n4);
            }
        }
        if (!this.L && !this.A) {
            this.A = true;
            this.L = true;
        }
        if (this.K == null) {
            this.K = System.getProperty("user.dir");
        }
        this.S = new File(this.K);
        if (!this.S.isDirectory()) {
            MCT.B("Destination <" + this.S.getName() + "> is not a directory");
        }
        try {
            this.T = Class.forName(this.X + "." + this.R + "_Algorithm");
            Method[] methodArray = this.T.getDeclaredMethods();
            for (n3 = 0; n3 < methodArray.length; ++n3) {
                String string2 = methodArray[n3].getName();
                int n6 = methodArray[n3].getParameterTypes().length;
                if (string2.equals("blockSize")) {
                    this.G = methodArray[n3];
                    continue;
                }
                if (string2.equals("makeKey") && n6 == 1) {
                    this.Q = methodArray[n3];
                    continue;
                }
                if (string2.equals("blockEncrypt") && n6 == 3) {
                    this.P = methodArray[n3];
                    continue;
                }
                if (!string2.equals("blockDecrypt") || n6 != 3) continue;
                this.C = methodArray[n3];
            }
            if (this.G == null) {
                throw new NoSuchMethodException("blockSize()");
            }
            if (this.Q == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.P == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.C == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MCT.C("Unable to find a " + this.R + "_Algorithm class");
            this.T = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MCT.C("Unable to find method " + noSuchMethodException.getMessage() + " in " + this.R + "_Algorithm class");
            this.T = null;
        }
        try {
            this.B = Cipher.getInstance(this.R + "/ECB", this.X);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            MCT.B("Unable to locate Security Provider: " + this.X);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            MCT.B("Unable to locate an implementation for Cipher: " + this.R + "/ECB");
        }
        this.F = this.T != null;
    }

    static void B(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void C(String string) {
        System.out.println("MCT: " + string + "...");
    }

    void A() {
        System.out.println("NAME\n  MCT: A Monte Carlo Tests data generator/exerciser for any block\n  cipher algorithm.\n\nSYNTAX\n  java cryptix.tools.MCT\n    [ -e | -c ]\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    [ -p <provider>]\n    <cipher>\n\nDESCRIPTION\n  For a designated symmetric block cipher algorithm, this command\n  generates and exercises Monte Carlo Tests data for both Encryption\n  and Decryption in Electronic Codebook (ECB) and Cipher Block Chaining\n  (CBC) modes.\n  MCT's output file format is in conformance with the layout described\n  in Section 4 of NIST's document \"Description of Known Answer Tests\n  and Monte Carlo Tests for Advanced Encryption Standard (AES) Candidate\n  Algorithm Submissions\" dated January 7, 1998.\n\nOPTIONS\n  -e   Generate both Encryption and Decryption data for the cipher in\n       ECB mode only.  By default MCT generates both ECB and CBC test\n       suites.\n\n  -c   Generate both Encryption and Decryption data for the cipher in\n       CBC mode only.  By default MCT generates both ECB and CBC test\n       suites.\n\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where the output files: \"ecb_e_m.txt\",\n       \"ecb_d_m.txt\", \"cbc_e_m.txt\" and \"cbc_d_m.txt\" will be generated.\n       If this destination directory is not specified, those files will\n       be placed in the current user directory.\n\n  -p <provider>\n       Name of the Security Provider for the designated algorithm.\n       If omitted, then assumes provider has the same name as the\n       algorithm itself.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void B() {
        long l2 = System.currentTimeMillis();
        try {
            if (this.L) {
                this.B("ecb_e_m.txt", "ecb_d_m.txt");
            }
            if (this.A) {
                this.A("cbc_e_m.txt", "cbc_d_m.txt");
            }
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            MCT.B("Key Exception encountered\n" + keyException.getMessage());
        }
        MCT.C("Java interpreter used: Version " + System.getProperty("java.version"));
        MCT.C("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        MCT.C("Total execution time (ms): " + (System.currentTimeMillis() - l2));
        MCT.C("During this time, " + this.R + ":");
        MCT.C("  Encrypted " + this.W + " blocks");
        MCT.C("  Decrypted " + this.J + " blocks");
        MCT.C("  Created " + this.I + " session keys");
    }

    void B(String string, String string2) throws KeyException {
        PrintWriter printWriter = null;
        File file = new File(this.S, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.B("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        PrintWriter printWriter2 = null;
        File file2 = new File(this.S, string2);
        try {
            printWriter2 = new PrintWriter((Writer)new FileWriter(file2), true);
        }
        catch (IOException iOException) {
            MCT.B("Unable to initialize <" + string2 + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode - ENCRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.R);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        printWriter2.println();
        printWriter2.println("=========================");
        printWriter2.println();
        printWriter2.println("FILENAME:  \"" + string2 + "\"");
        printWriter2.println();
        printWriter2.println("Electronic Codebook (ECB) Mode - DECRYPTION");
        printWriter2.println("Monte Carlo Test");
        printWriter2.println();
        printWriter2.println("Algorithm Name: " + this.R);
        printWriter2.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter2.println();
        boolean bl = true;
        if (this.F) {
            try {
                for (int i2 = 0; i2 < this.N.length; ++i2) {
                    this.B(this.N[i2], printWriter, printWriter2);
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                MCT.C("Exception while invoking a method in " + this.R + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                MCT.B("Exception encountered in a " + this.R + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            for (int i3 = 0; i3 < this.N.length; ++i3) {
                this.A(this.N[i3], printWriter, printWriter2);
            }
        }
        printWriter.println("==========");
        printWriter2.println("==========");
        printWriter.close();
        printWriter2.close();
    }

    void B(int n2, PrintWriter printWriter, PrintWriter printWriter2) throws IllegalAccessException, InvocationTargetException {
        MCT.C("Processing MCT in ECB mode (long); key size: " + n2);
        MCT.C("Using Reflection API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter2.println("==========");
        printWriter2.println();
        printWriter2.println("KEYSIZE=" + n2);
        printWriter2.println();
        Object[] objectArray = new Object[]{};
        int n3 = n2 / 8;
        byte[] byArray = new byte[n3];
        int n4 = (Integer)this.G.invoke(null, objectArray);
        byte[] byArray2 = new byte[n4];
        for (int i2 = 0; i2 < 400; ++i2) {
            int n5;
            int n6;
            String string = Hex.toString(byArray);
            objectArray = new Object[]{byArray};
            Object object = this.Q.invoke(null, objectArray);
            ++this.I;
            printWriter.println("I=" + i2);
            printWriter.println("KEY=" + string);
            printWriter.println("PT=" + Hex.toString(byArray2));
            objectArray = new Object[]{byArray2, new Integer(0), object};
            byte[] byArray3 = (byte[])this.P.invoke(null, objectArray);
            for (n6 = 1; n6 < 9999; ++n6) {
                objectArray[0] = byArray3;
                byArray3 = (byte[])this.P.invoke(null, objectArray);
                ++this.W;
            }
            objectArray[0] = byArray3;
            byte[] byArray4 = (byte[])this.P.invoke(null, objectArray);
            ++this.W;
            String string2 = Hex.toString(byArray4);
            printWriter.println("CT=" + string2);
            printWriter2.println("I=" + i2);
            printWriter2.println("KEY=" + string);
            printWriter2.println("CT=" + string2);
            objectArray[0] = byArray4;
            byte[] byArray5 = (byte[])this.C.invoke(null, objectArray);
            ++this.J;
            for (n6 = 1; n6 < 10000; ++n6) {
                objectArray[0] = byArray5;
                byArray5 = (byte[])this.C.invoke(null, objectArray);
                ++this.J;
            }
            printWriter2.println("PT=" + Hex.toString(byArray5));
            if (!ArrayUtil.areEqual(byArray2, byArray5)) {
                printWriter.println(" *** ERROR ***");
                printWriter2.println(" *** ERROR ***");
                MCT.B("ECB Encryption/Decryption mismatch");
            }
            printWriter.println();
            printWriter2.println();
            n6 = 0;
            if (n3 > n4) {
                int n7 = n3 - n4;
                n5 = n4 - n7;
                while (n6 < n7) {
                    int n8 = n6++;
                    byArray[n8] = (byte)(byArray[n8] ^ byArray3[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n3) {
                int n9 = n6++;
                byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
            }
            System.arraycopy(byArray4, 0, byArray2, 0, n4);
        }
    }

    void A(int n2, PrintWriter printWriter, PrintWriter printWriter2) throws KeyException {
        MCT.C("Processing MCT in ECB mode (long); key size: " + n2);
        MCT.C("Using IJCE API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter2.println("==========");
        printWriter2.println();
        printWriter2.println("KEYSIZE=" + n2);
        printWriter2.println();
        int n3 = n2 / 8;
        byte[] byArray = new byte[n3];
        int n4 = this.B.blockSize();
        byte[] byArray2 = new byte[n4];
        for (int i2 = 0; i2 < 400; ++i2) {
            int n5;
            int n6;
            String string = Hex.toString(byArray);
            _A _A2 = new _A(byArray);
            printWriter.println("I=" + i2);
            printWriter.println("KEY=" + string);
            printWriter.println("PT=" + Hex.toString(byArray2));
            this.B.initEncrypt(_A2);
            ++this.I;
            byte[] byArray3 = this.B.crypt(byArray2);
            ++this.W;
            for (n6 = 1; n6 < 9999; ++n6) {
                byArray3 = this.B.crypt(byArray3);
                ++this.W;
            }
            byte[] byArray4 = this.B.crypt(byArray3);
            ++this.W;
            String string2 = Hex.toString(byArray4);
            printWriter.println("CT=" + string2);
            printWriter2.println("I=" + i2);
            printWriter2.println("KEY=" + string);
            printWriter2.println("CT=" + string2);
            this.B.initDecrypt(_A2);
            ++this.I;
            byte[] byArray5 = this.B.crypt(byArray4);
            ++this.J;
            for (n6 = 1; n6 < 10000; ++n6) {
                byArray5 = this.B.crypt(byArray5);
                ++this.J;
            }
            printWriter2.println("PT=" + Hex.toString(byArray5));
            if (!ArrayUtil.areEqual(byArray2, byArray5)) {
                printWriter.println(" *** ERROR ***");
                printWriter2.println(" *** ERROR ***");
                MCT.B("ECB Encryption/Decryption mismatch");
            }
            printWriter.println();
            printWriter2.println();
            n6 = 0;
            if (n3 > n4) {
                int n7 = n3 - n4;
                n5 = n4 - n7;
                while (n6 < n7) {
                    int n8 = n6++;
                    byArray[n8] = (byte)(byArray[n8] ^ byArray3[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n3) {
                int n9 = n6++;
                byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
            }
            System.arraycopy(byArray4, 0, byArray2, 0, n4);
        }
    }

    void A(String string, String string2) throws KeyException {
        this.A(string);
        this.D(string2);
    }

    void A(String string) throws KeyException {
        PrintWriter printWriter = null;
        File file = new File(this.S, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.B("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Cipher Block Chaining (CBC) Mode - ENCRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.R);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = true;
        if (this.F) {
            try {
                for (int i2 = 0; i2 < this.N.length; ++i2) {
                    this.B(this.N[i2], printWriter);
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                MCT.C("Exception while invoking a method in " + this.R + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                MCT.B("Exception encountered in a " + this.R + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            for (int i3 = 0; i3 < this.N.length; ++i3) {
                this.D(this.N[i3], printWriter);
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void B(int n2, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.C("Processing MCT in CBC-Encrypt mode (long); key size: " + n2);
        MCT.C("Using Reflection API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n3 = n2 / 8;
        byte[] byArray = new byte[n3];
        int n4 = (Integer)this.G.invoke(null, objectArray);
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray3, 0, n4);
        for (int i2 = 0; i2 < 400; ++i2) {
            int n5;
            int n6;
            printWriter.println("I=" + i2);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("PT=" + Hex.toString(byArray2));
            objectArray = new Object[]{byArray};
            Object object = this.Q.invoke(null, objectArray);
            ++this.I;
            objectArray = new Object[3];
            objectArray[1] = new Integer(0);
            objectArray[2] = object;
            for (n6 = 0; n6 < 10000; ++n6) {
                for (n5 = 0; n5 < n4; ++n5) {
                    int n7 = n5;
                    byArray4[n7] = (byte)(byArray4[n7] ^ byArray2[n5]);
                }
                System.arraycopy(byArray3, 0, byArray2, 0, n4);
                objectArray[0] = byArray4;
                byArray3 = (byte[])this.P.invoke(null, objectArray);
                ++this.W;
                System.arraycopy(byArray3, 0, byArray4, 0, n4);
            }
            printWriter.println("CT=" + Hex.toString(byArray3));
            printWriter.println();
            n6 = 0;
            if (n3 > n4) {
                int n8 = n3 - n4;
                n5 = n4 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray2[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n3) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray3[n5++]);
            }
        }
    }

    void D(int n2, PrintWriter printWriter) throws KeyException {
        MCT.C("Processing MCT in CBC-Encrypt mode (long); key size: " + n2);
        MCT.C("Using IJCE API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        int n3 = n2 / 8;
        byte[] byArray = new byte[n3];
        int n4 = this.B.blockSize();
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray3, 0, n4);
        for (int i2 = 0; i2 < 400; ++i2) {
            int n5;
            int n6;
            printWriter.println("I=" + i2);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("PT=" + Hex.toString(byArray2));
            _A _A2 = new _A(byArray);
            this.B.initEncrypt(_A2);
            ++this.I;
            for (n6 = 0; n6 < 10000; ++n6) {
                for (n5 = 0; n5 < n4; ++n5) {
                    int n7 = n5;
                    byArray4[n7] = (byte)(byArray4[n7] ^ byArray2[n5]);
                }
                System.arraycopy(byArray3, 0, byArray2, 0, n4);
                byArray3 = this.B.crypt(byArray4);
                ++this.W;
                System.arraycopy(byArray3, 0, byArray4, 0, n4);
            }
            printWriter.println("CT=" + Hex.toString(byArray3));
            printWriter.println();
            n6 = 0;
            if (n3 > n4) {
                int n8 = n3 - n4;
                n5 = n4 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray2[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n3) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray3[n5++]);
            }
        }
    }

    void D(String string) throws KeyException {
        PrintWriter printWriter = null;
        File file = new File(this.S, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.B("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Cipher Block Chaining (CBC) Mode - DECRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.R);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = false;
        if (this.F) {
            try {
                for (int i2 = 128; i2 < 257; i2 += 64) {
                    this.C(i2, printWriter);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                MCT.C("Exception while invoking a method in " + this.R + "_Algorithm class");
                bl = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                MCT.B("Exception encountered in a " + this.R + "_Algorithm method:\n" + invocationTargetException.getMessage());
            }
        }
        if (bl) {
            for (int i3 = 128; i3 < 257; i3 += 64) {
                this.A(i3, printWriter);
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void C(int n2, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.C("Processing MCT in CBC-Decrypt mode (long); key size: " + n2);
        MCT.C("Using Reflection API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n3 = n2 / 8;
        byte[] byArray = new byte[n3];
        int n4 = (Integer)this.G.invoke(null, objectArray);
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n4];
        for (int i2 = 0; i2 < 400; ++i2) {
            int n5;
            int n6;
            printWriter.println("I=" + i2);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("CT=" + Hex.toString(byArray3));
            objectArray = new Object[]{byArray};
            Object object = this.Q.invoke(null, objectArray);
            ++this.I;
            objectArray = new Object[3];
            objectArray[1] = new Integer(0);
            objectArray[2] = object;
            for (n6 = 0; n6 < 10000; ++n6) {
                objectArray[0] = byArray3;
                byArray2 = (byte[])this.C.invoke(null, objectArray);
                ++this.J;
                for (n5 = 0; n5 < n4; ++n5) {
                    int n7 = n5;
                    byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n5]);
                }
                System.arraycopy(byArray3, 0, byArray4, 0, n4);
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
            }
            printWriter.println("PT=" + Hex.toString(byArray2));
            printWriter.println();
            n6 = 0;
            if (n3 > n4) {
                int n8 = n3 - n4;
                n5 = n4 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n3) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray2[n5++]);
            }
        }
    }

    void A(int n2, PrintWriter printWriter) throws KeyException {
        MCT.C("Processing MCT in CBC-Decrypt mode (long); key size: " + n2);
        MCT.C("Using IJCE API methods");
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        int n3 = n2 / 8;
        byte[] byArray = new byte[n3];
        int n4 = this.B.blockSize();
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n4];
        for (int i2 = 0; i2 < 400; ++i2) {
            int n5;
            int n6;
            printWriter.println("I=" + i2);
            printWriter.println("KEY=" + Hex.toString(byArray));
            printWriter.println("IV=" + Hex.toString(byArray4));
            printWriter.println("CT=" + Hex.toString(byArray3));
            _A _A2 = new _A(byArray);
            this.B.initDecrypt(_A2);
            ++this.I;
            for (n6 = 0; n6 < 10000; ++n6) {
                byArray2 = this.B.crypt(byArray3);
                ++this.J;
                for (n5 = 0; n5 < n4; ++n5) {
                    int n7 = n5;
                    byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n5]);
                }
                System.arraycopy(byArray3, 0, byArray4, 0, n4);
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
            }
            printWriter.println("PT=" + Hex.toString(byArray2));
            printWriter.println();
            n6 = 0;
            if (n3 > n4) {
                int n8 = n3 - n4;
                n5 = n4 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n3) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray2[n5++]);
            }
        }
    }

    final class _A
    implements SecretKey {
        byte[] E;

        public _A(byte[] byArray) {
            this.E = (byte[])byArray.clone();
        }

        public String getAlgorithm() {
            return "<ANY>";
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.E.clone();
        }
    }
}

