/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.checksum;

import java.util.zip.Checksum;

public class PRZ24
implements Checksum {
    private static final int[] C = new int[256];
    private static final int E = 24;
    private static final int D = 0x1000000;
    private static final int B = 0xFFFFFF;
    private static final int F = 8801531;
    private static final int A = 11994318;
    private int G;

    public PRZ24() {
        this.reset();
    }

    public void reset() {
        this.G = 11994318;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 + n2 > byArray.length) {
            n3 = byArray.length - n2;
        }
        while (n3-- > 0) {
            this.update(byArray[n2++]);
        }
    }

    public void update(int n2) {
        this.G = (this.G << 8 ^ C[this.G >>> 16 ^ n2 & 0xFF]) & 0xFFFFFF;
    }

    public long getValue() {
        return (long)this.G & 0xFFFFFFFFL;
    }

    static {
        PRZ24.C[0] = 0;
        PRZ24.C[1] = 8801531;
        int n2 = 2;
        for (int i2 = 1; i2 < 128; ++i2) {
            int n3 = C[i2] << 1;
            if ((n3 & 0x1000000) != 0) {
                PRZ24.C[n2++] = n3 ^ 0x864CFB;
                PRZ24.C[n2++] = n3;
                continue;
            }
            PRZ24.C[n2++] = n3;
            PRZ24.C[n2++] = n3 ^ 0x864CFB;
        }
    }
}

