/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelExtendedData
extends SshMessage {
    public static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    public static final int SSH_EXTENDED_DATA_STDERR = 1;
    private byte[] D;
    private int B;
    private long C;

    public SshMsgChannelExtendedData(long l2, int n2, byte[] byArray) {
        super(95);
        this.C = l2;
        this.B = n2;
        this.D = byArray;
    }

    public SshMsgChannelExtendedData() {
        super(95);
    }

    public byte[] getChannelData() {
        return this.D;
    }

    public int getDataTypeCode() {
        return this.B;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_EXTENDED_DATA";
    }

    public long getRecipientChannel() {
        return this.C;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeInt(this.C);
            byteArrayWriter.writeInt(this.B);
            if (this.D != null) {
                byteArrayWriter.writeBinaryString(this.D);
            } else {
                byteArrayWriter.writeString("");
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data", iOException);
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.C = byteArrayReader.readInt();
            this.B = (int)byteArrayReader.readInt();
            if (byteArrayReader.available() > 0) {
                this.D = byteArrayReader.readBinaryString();
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data", iOException);
        }
    }
}

