/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.DERUtils;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.net.puretls.sslg.Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;

public class X509Ext
implements Extension {
    private byte[] A;
    private boolean C;
    private byte[] B;

    X509Ext(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = DERUtils.decodeSequence(byteArrayInputStream);
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        this.A = DERUtils.decodeOID(byteArrayInputStream);
        if (DERUtils.isTag(1, byteArrayInputStream)) {
            this.C = DERUtils.decodeBoolean(byteArrayInputStream);
        }
        this.B = DERUtils.decodeAny(byteArrayInputStream);
    }

    public byte[] getOID() {
        return this.A;
    }

    public boolean isCritical() {
        return this.C;
    }

    public byte[] getValue() {
        return this.B;
    }

    static X509Ext A(X509Cert x509Cert, byte[] byArray) throws IOException {
        X509Ext x509Ext = null;
        Vector vector = x509Cert.getExtensions();
        if (vector == null) {
            SSLDebug.debug(32, "No extensions found");
            return null;
        }
        SSLDebug.debug(32, "Number of extensions = ", vector.size());
        SSLDebug.debug(32, "Looking for extension", byArray);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            X509Ext x509Ext2 = (X509Ext)vector.elementAt(i2);
            SSLDebug.debug(32, "Found extension", x509Ext2.getOID());
            if (!ArrayUtil.areEqual(x509Ext2.getOID(), byArray)) continue;
            if (x509Ext != null) {
                throw new IOException("Can't have two extensions of this type");
            }
            x509Ext = x509Ext2;
        }
        return x509Ext;
    }
}

