/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.messaging.core.impl.message.MessageFactory;

public class SessionSendRequest
extends RequestSupport {
    private JBossMessage msg;
    private boolean checkForDuplicates;

    public SessionSendRequest() {
    }

    public SessionSendRequest(String objectId, byte version, JBossMessage msg, boolean checkForDuplicates) {
        super(objectId, 312, version);
        this.msg = msg;
        this.checkForDuplicates = checkForDuplicates;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        byte messageType = is.readByte();
        this.msg = (JBossMessage)MessageFactory.createMessage(messageType);
        this.msg.read(is);
        this.checkForDuplicates = is.readBoolean();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.send(this.msg, this.checkForDuplicates);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeByte(this.msg.getType());
        this.msg.write(os);
        os.writeBoolean(this.checkForDuplicates);
        os.flush();
    }
}

