/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.io.Externalizable;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.jboss.iiop.rmi.AbstractAnalysis;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.ClassAnalysis;
import org.jboss.iiop.rmi.ConstantAnalysis;
import org.jboss.iiop.rmi.InterfaceAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.ParameterAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.RmiIdlUtil;
import org.jboss.iiop.rmi.Util;
import org.jboss.iiop.rmi.ValueAnalysis;
import org.jboss.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;

public abstract class ContainerAnalysis
extends ClassAnalysis {
    protected final byte M_OVERLOADED = 1;
    protected final byte M_READ = (byte)2;
    protected final byte M_WRITE = (byte)4;
    protected final byte M_READONLY = (byte)8;
    protected final byte M_INHERITED = (byte)16;
    protected final byte M_WRITEOBJECT = (byte)32;
    protected final byte F_CONSTANT = 1;
    protected final byte F_SPFFIELD = (byte)2;
    protected Method[] methods;
    protected byte[] m_flags;
    protected int[] mutators;
    protected Field[] fields;
    protected byte[] f_flags;
    protected long classHashCode = 0L;
    protected String repositoryId;
    protected String memberPrefix;
    protected String memberPostfix;
    protected InterfaceAnalysis[] interfaces;
    protected ValueAnalysis[] abstractBaseValuetypes;
    protected AttributeAnalysis[] attributes;
    protected ConstantAnalysis[] constants;
    protected OperationAnalysis[] operations;
    private static final Logger logger = Logger.getLogger(ContainerAnalysis.class);
    private String idlModuleName = null;

    protected ContainerAnalysis(Class cls) {
        super(cls);
        if (cls == java.lang.Object.class || cls == Serializable.class || cls == Externalizable.class) {
            throw new IllegalArgumentException("Cannot analyze special class: " + cls.getName());
        }
        this.cls = cls;
    }

    protected void doAnalyze() throws RMIIIOPViolationException {
        this.analyzeInterfaces();
        this.analyzeMethods();
        this.analyzeFields();
        this.calculateClassHashCode();
        this.calculateRepositoryId();
        this.analyzeAttributes();
        this.analyzeConstants();
        this.analyzeOperations();
        this.fixupOverloadedOperationNames();
    }

    public InterfaceAnalysis[] getInterfaces() {
        logger.debug(this.cls + " Interface count: " + this.interfaces.length);
        return (InterfaceAnalysis[])this.interfaces.clone();
    }

    public ValueAnalysis[] getAbstractBaseValuetypes() {
        logger.debug(this.cls + " Abstract base valuetype count: " + this.abstractBaseValuetypes.length);
        return (ValueAnalysis[])this.abstractBaseValuetypes.clone();
    }

    public AttributeAnalysis[] getAttributes() {
        logger.debug(this.cls + " Attribute count: " + this.attributes.length);
        return (AttributeAnalysis[])this.attributes.clone();
    }

    public ConstantAnalysis[] getConstants() {
        logger.debug(this.cls + " Constants count: " + this.constants.length);
        return (ConstantAnalysis[])this.constants.clone();
    }

    public OperationAnalysis[] getOperations() {
        logger.debug(this.cls + " Operations count: " + this.operations.length);
        return (OperationAnalysis[])this.operations.clone();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getMemberRepositoryId(String memberName) {
        return this.memberPrefix + this.escapeIRName(memberName) + this.memberPostfix;
    }

    public String getIDLModuleName() {
        if (this.idlModuleName == null) {
            String pkgName = this.cls.getPackage().getName();
            StringBuffer b = new StringBuffer();
            while (!"".equals(pkgName)) {
                int idx = pkgName.indexOf(46);
                String n = idx == -1 ? pkgName : pkgName.substring(0, idx);
                b.append("::").append(Util.javaToIDLName(n));
                pkgName = idx == -1 ? "" : pkgName.substring(idx + 1);
            }
            this.idlModuleName = b.toString();
        }
        return this.idlModuleName;
    }

    protected String toHexString(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() < 8) {
            return "00000000".substring(0, 8 - s.length()) + s;
        }
        return s;
    }

    protected String toHexString(long l) {
        String s = Long.toHexString(l).toUpperCase();
        if (s.length() < 16) {
            return "0000000000000000".substring(0, 16 - s.length()) + s;
        }
        return s;
    }

    protected boolean isAccessor(Method m) {
        Class<?> returnType = m.getReturnType();
        if (!(m.getName().startsWith("get") || m.getName().startsWith("is") && returnType == Boolean.TYPE)) {
            return false;
        }
        if (returnType == Void.TYPE) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return this.hasNonAppExceptions(m);
    }

    protected boolean isMutator(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        if (m.getReturnType() != Void.TYPE) {
            return false;
        }
        if (m.getParameterTypes().length != 1) {
            return false;
        }
        return this.hasNonAppExceptions(m);
    }

    protected boolean hasNonAppExceptions(Method m) {
        Class<?>[] ex = m.getExceptionTypes();
        for (int i = 0; i < ex.length; ++i) {
            if (RemoteException.class.isAssignableFrom(ex[i])) continue;
            return false;
        }
        return true;
    }

    protected void analyzeFields() {
        logger.debug(this.cls + " analyzeFields");
        this.fields = this.cls.getDeclaredFields();
        this.f_flags = new byte[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int mods = this.fields[i].getModifiers();
            if (!Modifier.isFinal(mods) || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) continue;
            int n = i;
            this.f_flags[n] = (byte)(this.f_flags[n] | 1);
        }
        logger.debug(this.cls + " analyzeFields fields=" + this.fields.length);
    }

    protected void analyzeInterfaces() throws RMIIIOPViolationException {
        logger.debug(this.cls + " analyzeInterfaces");
        Class<?>[] intfs = this.cls.getInterfaces();
        ArrayList<InterfaceAnalysis> a = new ArrayList<InterfaceAnalysis>();
        ArrayList<ValueAnalysis> b = new ArrayList<ValueAnalysis>();
        for (int i = 0; i < intfs.length; ++i) {
            if (intfs[i] == Remote.class || intfs[i] == Serializable.class || intfs[i] == Externalizable.class) continue;
            if (!RmiIdlUtil.isAbstractValueType(intfs[i])) {
                a.add(InterfaceAnalysis.getInterfaceAnalysis(intfs[i]));
                continue;
            }
            b.add(ValueAnalysis.getValueAnalysis(intfs[i]));
        }
        this.interfaces = new InterfaceAnalysis[a.size()];
        this.interfaces = a.toArray(this.interfaces);
        this.abstractBaseValuetypes = new ValueAnalysis[b.size()];
        this.abstractBaseValuetypes = b.toArray(this.abstractBaseValuetypes);
        logger.debug(this.cls + " analyzeInterfaces interfaces=" + this.interfaces.length + " abstractBaseValueTypes=" + this.abstractBaseValuetypes.length);
    }

    protected void analyzeMethods() {
        int i;
        logger.debug(this.cls + " analyzeMethods");
        this.methods = this.cls.isInterface() && Remote.class.isAssignableFrom(this.cls) ? this.cls.getMethods() : this.cls.getDeclaredMethods();
        this.m_flags = new byte[this.methods.length];
        this.mutators = new int[this.methods.length];
        for (i = 0; i < this.methods.length; ++i) {
            this.mutators[i] = -1;
        }
        block1: for (i = 0; i < this.methods.length; ++i) {
            int j;
            String attrName;
            logger.debug("analyzeMethods(): method[" + i + "].getName()=\"" + this.methods[i].getName() + "\".");
            if (this.isAccessor(this.methods[i]) && (this.m_flags[i] & 2) == 0) {
                attrName = this.attributeReadName(this.methods[i].getName());
                Class<?> iReturn = this.methods[i].getReturnType();
                for (j = i + 1; j < this.methods.length; ++j) {
                    Class<?>[] jParams;
                    if (!this.isMutator(this.methods[j]) || (this.m_flags[j] & 4) != 0 || !attrName.equals(this.attributeWriteName(this.methods[j].getName())) || (jParams = this.methods[j].getParameterTypes()).length != 1 || jParams[0] != iReturn) continue;
                    int n = i;
                    this.m_flags[n] = (byte)(this.m_flags[n] | 2);
                    int n2 = j;
                    this.m_flags[n2] = (byte)(this.m_flags[n2] | 4);
                    this.mutators[i] = j;
                    continue block1;
                }
                continue;
            }
            if (!this.isMutator(this.methods[i]) || (this.m_flags[i] & 4) != 0) continue;
            attrName = this.attributeWriteName(this.methods[i].getName());
            Class<?>[] iParams = this.methods[i].getParameterTypes();
            for (j = i + 1; j < this.methods.length; ++j) {
                if (!this.isAccessor(this.methods[j]) || (this.m_flags[j] & 2) != 0 || !attrName.equals(this.attributeReadName(this.methods[j].getName()))) continue;
                Class<?> jReturn = this.methods[j].getReturnType();
                if (iParams.length != 1 || iParams[0] != jReturn) continue;
                int n = i;
                this.m_flags[n] = (byte)(this.m_flags[n] | 4);
                int n3 = j;
                this.m_flags[n3] = (byte)(this.m_flags[n3] | 2);
                this.mutators[j] = i;
                continue block1;
            }
        }
        for (i = 0; i < this.methods.length; ++i) {
            if ((this.m_flags[i] & 6) != 0 || !this.isAccessor(this.methods[i])) continue;
            int n = i;
            this.m_flags[n] = (byte)(this.m_flags[n] | 8);
        }
        for (i = 0; i < this.methods.length; ++i) {
            if ((this.m_flags[i] & 0xE) == 0) {
                String iName = this.methods[i].getName();
                for (int j = i + 1; j < this.methods.length; ++j) {
                    if (!iName.equals(this.methods[j].getName())) continue;
                    int n = i;
                    this.m_flags[n] = (byte)(this.m_flags[n] | 1);
                    int n4 = j;
                    this.m_flags[n4] = (byte)(this.m_flags[n4] | 1);
                }
            }
            if (this.methods[i].getDeclaringClass() == this.cls) continue;
            int n = i;
            this.m_flags[n] = (byte)(this.m_flags[n] | 0x10);
        }
        logger.debug(this.cls + " analyzeMethods methods=" + this.methods.length);
    }

    protected String attributeReadName(String name) {
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        } else {
            throw new IllegalArgumentException("Not an accessor: " + name);
        }
        return name;
    }

    protected String attributeWriteName(String name) {
        if (!name.startsWith("set")) {
            throw new IllegalArgumentException("Not an accessor: " + name);
        }
        name = name.substring(3);
        return name;
    }

    protected void analyzeConstants() throws RMIIIOPViolationException {
        logger.debug(this.cls + " analyzeConstants");
        ArrayList<ConstantAnalysis> a = new ArrayList<ConstantAnalysis>();
        for (int i = 0; i < this.fields.length; ++i) {
            java.lang.Object value;
            logger.debug("f_flags[" + i + "]=" + this.f_flags[i]);
            if ((this.f_flags[i] & 1) == 0) continue;
            Class<?> type = this.fields[i].getType();
            if (!type.isPrimitive() && type != String.class) {
                if (!this.cls.isInterface()) continue;
                throw new RMIIIOPViolationException("Field \"" + this.fields[i].getName() + "\" of interface \"" + this.cls.getName() + "\" is a constant, but not of one " + "of the primitive types, or String.", "1.2.3");
            }
            String name = this.fields[i].getName();
            try {
                value = this.fields[i].get(null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.toString());
            }
            logger.debug("Constant[" + i + "] name= " + name);
            logger.debug("Constant[" + i + "] type= " + type.getName());
            logger.debug("Constant[" + i + "] value= " + value);
            a.add(new ConstantAnalysis(name, type, value));
        }
        this.constants = new ConstantAnalysis[a.size()];
        this.constants = a.toArray(this.constants);
        logger.debug(this.cls + " analyzeConstants constant=" + a.size());
    }

    protected void analyzeAttributes() throws RMIIIOPViolationException {
        logger.debug(this.cls + " analyzeAttributes");
        ArrayList<AttributeAnalysis> a = new ArrayList<AttributeAnalysis>();
        for (int i = 0; i < this.methods.length; ++i) {
            logger.debug("m_flags[" + i + "]=" + this.m_flags[i]);
            if ((this.m_flags[i] & 0xA) == 0) continue;
            String name = this.attributeReadName(this.methods[i].getName());
            logger.debug("Attribute[" + i + "] name= " + name);
            if ((this.m_flags[i] & 8) != 0) {
                a.add(new AttributeAnalysis(name, this.methods[i]));
                continue;
            }
            a.add(new AttributeAnalysis(name, this.methods[i], this.methods[this.mutators[i]]));
        }
        this.attributes = new AttributeAnalysis[a.size()];
        this.attributes = a.toArray(this.attributes);
        logger.debug(this.cls + " analyzeAttributes attributes=" + a.size());
    }

    protected void analyzeOperations() throws RMIIIOPViolationException {
        logger.debug(this.cls + " analyzeOperations");
        this.operations = new OperationAnalysis[0];
        logger.debug(this.cls + " analyzeOperations operations=" + this.operations.length);
    }

    protected void fixupOverloadedOperationNames() throws RMIIIOPViolationException {
        for (int i = 0; i < this.methods.length; ++i) {
            if ((this.m_flags[i] & 1) == 0) continue;
            OperationAnalysis oa = null;
            String javaName = this.methods[i].getName();
            for (int opIdx = 0; oa == null && opIdx < this.operations.length; ++opIdx) {
                if (!this.operations[opIdx].getMethod().equals(this.methods[i])) continue;
                oa = this.operations[opIdx];
            }
            if (oa == null) continue;
            ParameterAnalysis[] parms = oa.getParameters();
            StringBuffer b = new StringBuffer(oa.getIDLName());
            if (parms.length == 0) {
                b.append("__");
            }
            for (int j = 0; j < parms.length; ++j) {
                String s = parms[j].getTypeIDLName();
                if (s.startsWith("::")) {
                    s = s.substring(2);
                }
                if (s.startsWith("_")) {
                    s = s.substring(1);
                }
                b.append('_');
                while (!"".equals(s)) {
                    int idx = s.indexOf("::");
                    b.append('_');
                    if (idx == -1) {
                        b.append(s);
                        s = "";
                        continue;
                    }
                    b.append(s.substring(0, idx));
                    if (s.length() > idx + 2 && s.charAt(idx + 2) == '_') {
                        s = s.substring(idx + 3);
                        continue;
                    }
                    s = s.substring(idx + 2);
                }
            }
            oa.setIDLName(b.toString());
        }
    }

    protected void fixupCaseNames() throws RMIIIOPViolationException {
        AbstractAnalysis aa;
        int i;
        ArrayList entries = this.getContainedEntries();
        boolean[] clash = new boolean[entries.size()];
        String[] upperNames = new String[entries.size()];
        for (i = 0; i < entries.size(); ++i) {
            aa = (AbstractAnalysis)entries.get(i);
            clash[i] = false;
            upperNames[i] = aa.getIDLName().toUpperCase();
            for (int j = 0; j < i; ++j) {
                if (!upperNames[i].equals(upperNames[j])) continue;
                clash[i] = true;
                clash[j] = true;
            }
        }
        for (i = 0; i < entries.size(); ++i) {
            if (!clash[i]) continue;
            aa = (AbstractAnalysis)entries.get(i);
            boolean noUpper = true;
            String name = aa.getIDLName();
            StringBuffer b = new StringBuffer(name);
            b.append('_');
            for (int j = 0; j < name.length(); ++j) {
                if (!Character.isUpperCase(name.charAt(j))) continue;
                if (noUpper) {
                    noUpper = false;
                } else {
                    b.append('_');
                }
                b.append(j);
            }
            aa.setIDLName(b.toString());
        }
    }

    protected abstract ArrayList getContainedEntries();

    protected void calculateClassHashCode() {
        this.classHashCode = this.cls.isInterface() ? 0L : (!Serializable.class.isAssignableFrom(this.cls) ? 0L : (Externalizable.class.isAssignableFrom(this.cls) ? 1L : Util.getClassHashCode(this.cls)));
    }

    protected String escapeIRName(String name) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c < '\u0100') {
                b.append(c);
                continue;
            }
            b.append("\\U").append(this.toHexString(c));
        }
        return b.toString();
    }

    protected void calculateRepositoryId() {
        if (this.cls.isArray() || this.cls.isPrimitive()) {
            throw new IllegalArgumentException("Not a class or interface.");
        }
        if (this.cls.isInterface() && Object.class.isAssignableFrom(this.cls) && IDLEntity.class.isAssignableFrom(this.cls)) {
            StringBuffer b = new StringBuffer("IDL:");
            b.append(this.cls.getPackage().getName().replace('.', '/'));
            b.append('/');
            String base = this.cls.getName();
            base = base.substring(base.lastIndexOf(46) + 1);
            b.append(base).append(":1.0");
            this.repositoryId = b.toString();
        } else {
            StringBuffer b = new StringBuffer("RMI:");
            b.append(this.escapeIRName(this.cls.getName()));
            this.memberPrefix = b.toString() + ".";
            String hashStr = this.toHexString(this.classHashCode);
            b.append(':').append(hashStr);
            ObjectStreamClass osClass = ObjectStreamClass.lookup(this.cls);
            if (osClass != null) {
                long serialVersionUID = osClass.getSerialVersionUID();
                String SVUID = this.toHexString(serialVersionUID);
                if (this.classHashCode != serialVersionUID) {
                    b.append(':').append(SVUID);
                }
                this.memberPostfix = ":" + hashStr + ":" + SVUID;
            } else {
                this.memberPostfix = ":" + hashStr;
            }
            this.repositoryId = b.toString();
        }
    }
}

