// $ANTLR 2.7.6 (2005-12-22): "seam-text.g" -> "SeamTextParser.java"$

package org.jboss.seam.text;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

public class SeamTextParser extends antlr.LLkParser       implements SeamTextParserTokenTypes
 {
   
	private java.util.Set htmlElements = new java.util.HashSet( java.util.Arrays.asList( new String[] { "a", "p", "q", "code", "pre", "table", "tr", "td", "th", "ul", "ol", "li", "b", "i", "u", "tt", "del", "em", "hr", "br", "div", "span", "h1", "h2", "h3", "h4", "img" } ) );
	private java.util.Set htmlAttributes = new java.util.HashSet( java.util.Arrays.asList( new String[] { "src", "href", "lang", "class", "id", "style" } ) );
	
    private StringBuilder mainBuilder = new StringBuilder();
    private StringBuilder builder = mainBuilder;
    
    public String toString() {
        return builder.toString();
    }
    
    private void append(String... strings) {
        for (String string: strings) builder.append(string);
    }
    
    private static boolean hasMultiple(String string, char c) {
        return string.indexOf(c)!=string.lastIndexOf(c);
    }
    
    private void validateElement(Token t) throws NoViableAltException {
        if ( !htmlElements.contains( t.getText().toLowerCase() ) ) {
            throw new NoViableAltException(t, null);
        }
    }

    private void validateAttribute(Token t) throws NoViableAltException {
        if ( !htmlAttributes.contains( t.getText().toLowerCase() ) ) {
            throw new NoViableAltException(t, null);
        }
    }
    
    private void beginCapture() {
        builder = new StringBuilder();
    }
    
    private String endCapture() {
        String result = builder.toString();
        builder = mainBuilder;
        return result;
    }

    protected String linkTag(String description, String url) {
        return "<a href=\"" + url + "\" styleClass=\"seamTextLink\">" + description + "</a>";
    }

    protected String macroInclude(String macroName) {
        return "";
    }

protected SeamTextParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public SeamTextParser(TokenBuffer tokenBuf) {
  this(tokenBuf,4);
}

protected SeamTextParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public SeamTextParser(TokenStream lexer) {
  this(lexer,4);
}

public SeamTextParser(ParserSharedInputState state) {
  super(state,4);
  tokenNames = _tokenNames;
}

	public final void startRule() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			{
			_loop3:
			do {
				if ((LA(1)==NEWLINE)) {
					newline();
				}
				else {
					break _loop3;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case WORD:
			case PUNCTUATION:
			case ESCAPE:
			case STAR:
			case SLASH:
			case BAR:
			case HAT:
			case PLUS:
			case EQ:
			case HASH:
			case TWIDDLE:
			case UNDERSCORE:
			case OPEN:
			case LT:
			case DOUBLEQUOTE:
			case BACKTICK:
			case SPACE:
			{
				{
				switch ( LA(1)) {
				case PLUS:
				{
					heading();
					{
					_loop7:
					do {
						if ((LA(1)==NEWLINE)) {
							newline();
						}
						else {
							break _loop7;
						}
						
					} while (true);
					}
					break;
				}
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case STAR:
				case SLASH:
				case BAR:
				case HAT:
				case EQ:
				case HASH:
				case TWIDDLE:
				case UNDERSCORE:
				case OPEN:
				case LT:
				case DOUBLEQUOTE:
				case BACKTICK:
				case SPACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				text();
				{
				_loop11:
				do {
					if ((LA(1)==PLUS)) {
						heading();
						{
						_loop10:
						do {
							if ((LA(1)==NEWLINE)) {
								newline();
							}
							else {
								break _loop10;
							}
							
						} while (true);
						}
						text();
					}
					else {
						break _loop11;
					}
					
				} while (true);
				}
				break;
			}
			case EOF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_0);
		}
	}
	
	public final void newline() throws RecognitionException, TokenStreamException {
		
		Token  n = null;
		
		try {      // for error handling
			n = LT(1);
			match(NEWLINE);
			append( n.getText() );
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_1);
		}
	}
	
	public final void heading() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			{
			if ((LA(1)==PLUS) && (_tokenSet_2.member(LA(2)))) {
				h1();
			}
			else if ((LA(1)==PLUS) && (LA(2)==PLUS) && (_tokenSet_2.member(LA(3)))) {
				h2();
			}
			else if ((LA(1)==PLUS) && (LA(2)==PLUS) && (LA(3)==PLUS) && (_tokenSet_2.member(LA(4)))) {
				h3();
			}
			else if ((LA(1)==PLUS) && (LA(2)==PLUS) && (LA(3)==PLUS) && (LA(4)==PLUS)) {
				h4();
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			newlineOrEof();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_3);
		}
	}
	
	public final void text() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			{
			int _cnt17=0;
			_loop17:
			do {
				if ((_tokenSet_4.member(LA(1)))) {
					{
					switch ( LA(1)) {
					case WORD:
					case PUNCTUATION:
					case ESCAPE:
					case STAR:
					case SLASH:
					case BAR:
					case HAT:
					case TWIDDLE:
					case UNDERSCORE:
					case OPEN:
					case SPACE:
					{
						paragraph();
						break;
					}
					case EQ:
					case HASH:
					case DOUBLEQUOTE:
					case BACKTICK:
					{
						special();
						break;
					}
					case LT:
					{
						html();
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					{
					_loop16:
					do {
						if ((LA(1)==NEWLINE)) {
							newline();
						}
						else {
							break _loop16;
						}
						
					} while (true);
					}
				}
				else {
					if ( _cnt17>=1 ) { break _loop17; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt17++;
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_5);
		}
	}
	
	public final void paragraph() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			append("<p>\n");
			{
			int _cnt22=0;
			_loop22:
			do {
				if ((_tokenSet_2.member(LA(1)))) {
					line();
					newlineOrEof();
				}
				else {
					if ( _cnt22>=1 ) { break _loop22; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt22++;
			} while (true);
			}
			append("</p>\n");
			newlineOrEof();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_6);
		}
	}
	
	public final void special() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case BACKTICK:
			{
				preformatted();
				break;
			}
			case DOUBLEQUOTE:
			{
				quoted();
				break;
			}
			case EQ:
			case HASH:
			{
				list();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			newlineOrEof();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_6);
		}
	}
	
	public final void html() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			openTag();
			{
			_loop86:
			do {
				if ((LA(1)==SPACE) && (LA(2)==SLASH||LA(2)==GT||LA(2)==SPACE)) {
					space();
				}
				else if ((LA(1)==SPACE) && (LA(2)==WORD)) {
					space();
					attribute();
				}
				else {
					break _loop86;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case GT:
			{
				{
				beforeBody();
				body();
				closeTagWithBody();
				}
				break;
			}
			case SLASH:
			{
				closeTagWithNoBody();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_6);
		}
	}
	
	public final void preformatted() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(BACKTICK);
			append("<pre>");
			{
			_loop61:
			do {
				switch ( LA(1)) {
				case WORD:
				{
					word();
					break;
				}
				case PUNCTUATION:
				{
					punctuation();
					break;
				}
				case ESCAPE:
				case STAR:
				case SLASH:
				case BAR:
				case HAT:
				case PLUS:
				case EQ:
				case HASH:
				case TWIDDLE:
				case UNDERSCORE:
				{
					specialChars();
					break;
				}
				case OPEN:
				case CLOSE:
				{
					moreSpecialChars();
					break;
				}
				case GT:
				case LT:
				case DOUBLEQUOTE:
				case AMPERSAND:
				{
					htmlSpecialChars();
					break;
				}
				case SPACE:
				{
					space();
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					break _loop61;
				}
				}
			} while (true);
			}
			match(BACKTICK);
			append("</pre>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void quoted() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(DOUBLEQUOTE);
			append("<q>");
			{
			_loop65:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				case SLASH:
				case BAR:
				case HAT:
				case TWIDDLE:
				case UNDERSCORE:
				{
					formatted();
					break;
				}
				case BACKTICK:
				{
					preformatted();
					break;
				}
				case LT:
				{
					html();
					break;
				}
				case EQ:
				case HASH:
				{
					{
					list();
					newline();
					}
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					break _loop65;
				}
				}
			} while (true);
			}
			match(DOUBLEQUOTE);
			append("</q>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void list() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case HASH:
			{
				olist();
				break;
			}
			case EQ:
			{
				ulist();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void newlineOrEof() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case NEWLINE:
			{
				newline();
				break;
			}
			case EOF:
			{
				match(Token.EOF_TYPE);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_6);
		}
	}
	
	public final void line() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case WORD:
			case PUNCTUATION:
			case ESCAPE:
			case OPEN:
			case SPACE:
			{
				plain();
				break;
			}
			case STAR:
			case SLASH:
			case BAR:
			case HAT:
			case TWIDDLE:
			case UNDERSCORE:
			{
				formatted();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			_loop26:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				case SLASH:
				case BAR:
				case HAT:
				case TWIDDLE:
				case UNDERSCORE:
				{
					formatted();
					break;
				}
				case BACKTICK:
				{
					preformatted();
					break;
				}
				case DOUBLEQUOTE:
				{
					quoted();
					break;
				}
				case LT:
				{
					html();
					break;
				}
				default:
				{
					break _loop26;
				}
				}
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void plain() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case WORD:
			{
				word();
				break;
			}
			case PUNCTUATION:
			{
				punctuation();
				break;
			}
			case ESCAPE:
			{
				escape();
				break;
			}
			case SPACE:
			{
				space();
				break;
			}
			default:
				if ((LA(1)==OPEN) && (_tokenSet_9.member(LA(2)))) {
					link();
				}
				else if ((LA(1)==OPEN) && (LA(2)==LT)) {
					macro();
				}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void formatted() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case STAR:
			{
				bold();
				break;
			}
			case UNDERSCORE:
			{
				underline();
				break;
			}
			case SLASH:
			{
				italic();
				break;
			}
			case BAR:
			{
				monospace();
				break;
			}
			case HAT:
			{
				superscript();
				break;
			}
			case TWIDDLE:
			{
				deleted();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void bold() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(STAR);
			append("<b>");
			{
			int _cnt43=0;
			_loop43:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case UNDERSCORE:
				{
					underline();
					break;
				}
				case SLASH:
				{
					italic();
					break;
				}
				case BAR:
				{
					monospace();
					break;
				}
				case HAT:
				{
					superscript();
					break;
				}
				case TWIDDLE:
				{
					deleted();
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					if ( _cnt43>=1 ) { break _loop43; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				}
				_cnt43++;
			} while (true);
			}
			match(STAR);
			append("</b>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void underline() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(UNDERSCORE);
			append("<u>");
			{
			int _cnt46=0;
			_loop46:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				{
					bold();
					break;
				}
				case SLASH:
				{
					italic();
					break;
				}
				case BAR:
				{
					monospace();
					break;
				}
				case HAT:
				{
					superscript();
					break;
				}
				case TWIDDLE:
				{
					deleted();
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					if ( _cnt46>=1 ) { break _loop46; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				}
				_cnt46++;
			} while (true);
			}
			match(UNDERSCORE);
			append("</u>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void italic() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(SLASH);
			append("<i>");
			{
			int _cnt49=0;
			_loop49:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				{
					bold();
					break;
				}
				case UNDERSCORE:
				{
					underline();
					break;
				}
				case BAR:
				{
					monospace();
					break;
				}
				case HAT:
				{
					superscript();
					break;
				}
				case TWIDDLE:
				{
					deleted();
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					if ( _cnt49>=1 ) { break _loop49; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				}
				_cnt49++;
			} while (true);
			}
			match(SLASH);
			append("</i>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void monospace() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(BAR);
			append("<tt>");
			{
			int _cnt52=0;
			_loop52:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				{
					bold();
					break;
				}
				case UNDERSCORE:
				{
					underline();
					break;
				}
				case SLASH:
				{
					italic();
					break;
				}
				case HAT:
				{
					superscript();
					break;
				}
				case TWIDDLE:
				{
					deleted();
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					if ( _cnt52>=1 ) { break _loop52; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				}
				_cnt52++;
			} while (true);
			}
			match(BAR);
			append("</tt>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void superscript() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(HAT);
			append("<sup>");
			{
			int _cnt55=0;
			_loop55:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				{
					bold();
					break;
				}
				case UNDERSCORE:
				{
					underline();
					break;
				}
				case SLASH:
				{
					italic();
					break;
				}
				case BAR:
				{
					monospace();
					break;
				}
				case TWIDDLE:
				{
					deleted();
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					if ( _cnt55>=1 ) { break _loop55; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				}
				_cnt55++;
			} while (true);
			}
			match(HAT);
			append("</sup>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void deleted() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(TWIDDLE);
			append("<del>");
			{
			int _cnt58=0;
			_loop58:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				{
					bold();
					break;
				}
				case UNDERSCORE:
				{
					underline();
					break;
				}
				case SLASH:
				{
					italic();
					break;
				}
				case BAR:
				{
					monospace();
					break;
				}
				case HAT:
				{
					superscript();
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
				{
					if ( _cnt58>=1 ) { break _loop58; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				}
				_cnt58++;
			} while (true);
			}
			match(TWIDDLE);
			append("</del>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void word() throws RecognitionException, TokenStreamException {
		
		Token  w = null;
		
		try {      // for error handling
			w = LT(1);
			match(WORD);
			append( w.getText() );
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_1);
		}
	}
	
	public final void punctuation() throws RecognitionException, TokenStreamException {
		
		Token  p = null;
		
		try {      // for error handling
			p = LT(1);
			match(PUNCTUATION);
			append( p.getText() );
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_1);
		}
	}
	
	public final void escape() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(ESCAPE);
			{
			switch ( LA(1)) {
			case ESCAPE:
			case STAR:
			case SLASH:
			case BAR:
			case HAT:
			case PLUS:
			case EQ:
			case HASH:
			case TWIDDLE:
			case UNDERSCORE:
			{
				specialChars();
				break;
			}
			case OPEN:
			case CLOSE:
			{
				moreSpecialChars();
				break;
			}
			case QUOTE:
			{
				evenMoreSpecialChars();
				break;
			}
			case GT:
			case LT:
			case DOUBLEQUOTE:
			case AMPERSAND:
			{
				htmlSpecialChars();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void space() throws RecognitionException, TokenStreamException {
		
		Token  s = null;
		
		try {      // for error handling
			s = LT(1);
			match(SPACE);
			append( s.getText() );
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_1);
		}
	}
	
	public final void link() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(OPEN);
			beginCapture();
			{
			_loop39:
			do {
				if ((_tokenSet_10.member(LA(1)))) {
					plain();
				}
				else {
					break _loop39;
				}
				
			} while (true);
			}
			String text=endCapture();
			match(EQ);
			match(GT);
			beginCapture();
			attributeValue();
			String link = endCapture(); append(linkTag(text, link));
			match(CLOSE);
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void macro() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(OPEN);
			match(LT);
			match(EQ);
			beginCapture();
			attributeValue();
			String macroName = endCapture(); append(macroInclude(macroName));
			match(CLOSE);
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void specialChars() throws RecognitionException, TokenStreamException {
		
		Token  st = null;
		Token  sl = null;
		Token  b = null;
		Token  h = null;
		Token  p = null;
		Token  eq = null;
		Token  hh = null;
		Token  e = null;
		Token  t = null;
		Token  u = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case STAR:
			{
				st = LT(1);
				match(STAR);
				append( st.getText() );
				break;
			}
			case SLASH:
			{
				sl = LT(1);
				match(SLASH);
				append( sl.getText() );
				break;
			}
			case BAR:
			{
				b = LT(1);
				match(BAR);
				append( b.getText() );
				break;
			}
			case HAT:
			{
				h = LT(1);
				match(HAT);
				append( h.getText() );
				break;
			}
			case PLUS:
			{
				p = LT(1);
				match(PLUS);
				append( p.getText() );
				break;
			}
			case EQ:
			{
				eq = LT(1);
				match(EQ);
				append( eq.getText() );
				break;
			}
			case HASH:
			{
				hh = LT(1);
				match(HASH);
				append( hh.getText() );
				break;
			}
			case ESCAPE:
			{
				e = LT(1);
				match(ESCAPE);
				append( e.getText() );
				break;
			}
			case TWIDDLE:
			{
				t = LT(1);
				match(TWIDDLE);
				append( t.getText() );
				break;
			}
			case UNDERSCORE:
			{
				u = LT(1);
				match(UNDERSCORE);
				append( u.getText() );
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_1);
		}
	}
	
	public final void moreSpecialChars() throws RecognitionException, TokenStreamException {
		
		Token  o = null;
		Token  c = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case OPEN:
			{
				o = LT(1);
				match(OPEN);
				append( o.getText() );
				break;
			}
			case CLOSE:
			{
				c = LT(1);
				match(CLOSE);
				append( c.getText() );
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_1);
		}
	}
	
	public final void evenMoreSpecialChars() throws RecognitionException, TokenStreamException {
		
		Token  q = null;
		
		try {      // for error handling
			q = LT(1);
			match(QUOTE);
			append( q.getText() );
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_7);
		}
	}
	
	public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case GT:
			{
				match(GT);
				append("&gt;");
				break;
			}
			case LT:
			{
				match(LT);
				append("&lt;");
				break;
			}
			case DOUBLEQUOTE:
			{
				match(DOUBLEQUOTE);
				append("&quot;");
				break;
			}
			case AMPERSAND:
			{
				match(AMPERSAND);
				append("&amp;");
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_1);
		}
	}
	
	public final void attributeValue() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			{
			_loop104:
			do {
				switch ( LA(1)) {
				case AMPERSAND:
				{
					match(AMPERSAND);
					append("&amp;");
					break;
				}
				case WORD:
				{
					word();
					break;
				}
				case PUNCTUATION:
				{
					punctuation();
					break;
				}
				case SPACE:
				{
					space();
					break;
				}
				case ESCAPE:
				case STAR:
				case SLASH:
				case BAR:
				case HAT:
				case PLUS:
				case EQ:
				case HASH:
				case TWIDDLE:
				case UNDERSCORE:
				{
					specialChars();
					break;
				}
				default:
				{
					break _loop104;
				}
				}
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_11);
		}
	}
	
	public final void h1() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(PLUS);
			append("<h1>");
			line();
			append("</h1>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void h2() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(PLUS);
			match(PLUS);
			append("<h2>");
			line();
			append("</h2>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void h3() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(PLUS);
			match(PLUS);
			match(PLUS);
			append("<h3>");
			line();
			append("</h3>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void h4() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(PLUS);
			match(PLUS);
			match(PLUS);
			match(PLUS);
			append("<h4>");
			line();
			append("</h4>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void olist() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			append("<ol>\n");
			{
			int _cnt75=0;
			_loop75:
			do {
				if ((LA(1)==HASH)) {
					olistLine();
					newlineOrEof();
				}
				else {
					if ( _cnt75>=1 ) { break _loop75; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt75++;
			} while (true);
			}
			append("</ol>\n");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void ulist() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			append("<ul>\n");
			{
			int _cnt79=0;
			_loop79:
			do {
				if ((LA(1)==EQ)) {
					ulistLine();
					newlineOrEof();
				}
				else {
					if ( _cnt79>=1 ) { break _loop79; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt79++;
			} while (true);
			}
			append("</ul>\n");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void olistLine() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(HASH);
			append("<li>");
			line();
			append("</li>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void ulistLine() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(EQ);
			append("<li>");
			line();
			append("</li>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_8);
		}
	}
	
	public final void openTag() throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		
		try {      // for error handling
			match(LT);
			name = LT(1);
			match(WORD);
			validateElement(name); append("<"); append(name.getText());
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_12);
		}
	}
	
	public final void attribute() throws RecognitionException, TokenStreamException {
		
		Token  att = null;
		
		try {      // for error handling
			att = LT(1);
			match(WORD);
			{
			_loop99:
			do {
				if ((LA(1)==SPACE)) {
					space();
				}
				else {
					break _loop99;
				}
				
			} while (true);
			}
			match(EQ);
			{
			_loop101:
			do {
				if ((LA(1)==SPACE)) {
					space();
				}
				else {
					break _loop101;
				}
				
			} while (true);
			}
			match(DOUBLEQUOTE);
			validateAttribute(att); append(att.getText()); append("=\"");
			attributeValue();
			match(DOUBLEQUOTE);
			append("\"");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_12);
		}
	}
	
	public final void beforeBody() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(GT);
			append(">");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_3);
		}
	}
	
	public final void body() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			{
			_loop92:
			do {
				switch ( LA(1)) {
				case WORD:
				case PUNCTUATION:
				case ESCAPE:
				case OPEN:
				case SPACE:
				{
					plain();
					break;
				}
				case STAR:
				case SLASH:
				case BAR:
				case HAT:
				case TWIDDLE:
				case UNDERSCORE:
				{
					formatted();
					break;
				}
				case BACKTICK:
				{
					preformatted();
					break;
				}
				case DOUBLEQUOTE:
				{
					quoted();
					break;
				}
				case EQ:
				case HASH:
				{
					{
					list();
					newline();
					}
					break;
				}
				case NEWLINE:
				{
					newline();
					break;
				}
				default:
					if ((LA(1)==LT) && (LA(2)==WORD)) {
						html();
					}
				else {
					break _loop92;
				}
				}
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_13);
		}
	}
	
	public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		
		try {      // for error handling
			match(LT);
			match(SLASH);
			name = LT(1);
			match(WORD);
			match(GT);
			append("</"); append(name.getText()); append(">");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_6);
		}
	}
	
	public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(SLASH);
			match(GT);
			append("/>");
		}
		catch (RecognitionException ex) {
			reportError(ex);
			recover(ex,_tokenSet_6);
		}
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"WORD",
		"PUNCTUATION",
		"ESCAPE",
		"STAR",
		"SLASH",
		"BAR",
		"HAT",
		"PLUS",
		"EQ",
		"HASH",
		"TWIDDLE",
		"UNDERSCORE",
		"OPEN",
		"CLOSE",
		"QUOTE",
		"GT",
		"LT",
		"DOUBLEQUOTE",
		"AMPERSAND",
		"BACKTICK",
		"SPACE",
		"NEWLINE"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 2L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 66846706L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 16893936L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 61994992L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 28440560L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 2050L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { 61997042L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { 61994994L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 33554434L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 16846960L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 16842864L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 2228224L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 17301760L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = { 1048576L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	
	}
