/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ftp;

import org.jboss.system.ServiceMBeanSupport;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.ConfigurableFtpServerContext;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.ftplet.Configuration;

import java.net.URL;
import java.net.URI;
import java.io.InputStream;
import java.io.File;

/**
 * comment
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 1.1 $
 */
public class FTPServer extends ServiceMBeanSupport implements FTPServerMBean
{
   FtpServer server;

   @Override
   protected void startService() throws Exception
   {
      URL properties = Thread.currentThread().getContextClassLoader().getResource("res/conf/ftpd.properties");
      PathSubstitutionPropertiesConfiguration config = new PathSubstitutionPropertiesConfiguration(properties.openStream());

      URI uri = properties.toURI();
      File file = new File(uri);
      String path = file.getParentFile().getParentFile().getParentFile().toString();
      if (!path.endsWith("/")) path += "/";

      config.setBasePath(path);

      config.setProperty("config.user-manager.class", org.jboss.ftp.VirtualPropertiesUserManager.class.getName());
      config.setProperty("config.user-manager.admin-name", config.getString("config.user-manager.admin-name", "admin"));
      config.setProperty("config.user-manager.prop-file", path + "res/user.gen");
      log.info("prop-file path: " + path + "res/user.gen");
      config.setProperty("config.user-manager.encrypt-passwords", config.getString("config.user-manager.encrypt-passwords", "true"));
      config.setProperty("config.user-manager.base-path", path);

      FtpServerContext ftpConfig = new ConfigurableFtpServerContext(config);
      server = new FtpServer(ftpConfig);
      server.start();
      super.startService();
   }


   @Override
   protected void stopService() throws Exception
   {
      server.stop();
      super.stopService();    //To change body of overridden methods use File | Settings | File Templates.
   }
}
