/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ftp;

import org.apache.ftpserver.config.PropertiesConfiguration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.Configuration;

import java.io.InputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * Hack to replace all ./ in configuration files so that we can manage the server easily
 * yet embed it anywhere
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 1.1 $
 */
public class PathSubstitutionPropertiesConfiguration extends PropertiesConfiguration
{
   private String basePath;


   public PathSubstitutionPropertiesConfiguration()
   {
   }

   public PathSubstitutionPropertiesConfiguration(InputStream in)
           throws IOException
   {
      super(in);
   }

   public PathSubstitutionPropertiesConfiguration(Properties prop)
   {
      super(prop);
   }


   public String getBasePath()
   {
      return basePath;
   }

   public void setBasePath(String basePath)
   {
      this.basePath = basePath;
   }

   public void setProperty(String name, String value)
   {
      prop.setProperty(name, value);
   }


   @Override
   public Configuration subset(String param)
   {
      PathSubstitutionPropertiesConfiguration subConfig = new PathSubstitutionPropertiesConfiguration();
      subConfig.setBasePath(basePath);
      subConfig.prop = prop;
      subConfig.prefix = prefix + param + '.';
      return subConfig;
   }

   @Override
   public String getString(String param, String defaultVal)
   {
      String rtn = super.getString(param, defaultVal);
      if (rtn == null) return null;
      if (rtn.startsWith("./"))
      {
         rtn = basePath + rtn.substring(2);
      }
      return rtn;
   }

   @Override
   public String getString(String param) throws FtpException
   {
      String rtn = super.getString(param);
      if (rtn == null) return null;
      if (rtn.startsWith("./"))
      {
         rtn = basePath + rtn.substring(2);
      }
      return rtn;
   }
}
