/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.rosetta.pooling.xa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.transaction.Synchronization;

import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.internal.soa.esb.rosetta.pooling.xa.XaJmsConnectionPool;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;

public class XaJmsConnectionPoolContainer extends JmsConnectionPoolContainer
{

    public static JmsConnectionPool getPool (Properties enviroment,
	    String connectionFactory, String destinationType,
	    final String username, final String password,
	    final boolean transacted, final Object transaction)
	    throws ConnectionException
    {
	synchronized (transactions)
	{
	    JmsConnectionPool connection = transactions.get(transaction);

	    if (connection == null)
	    {
		// we could override the connectionfactory name here ...
		// in fact we could change all of the info here if necessary ...
		
		Map<String, String> poolKey = createPoolKey(enviroment,
			connectionFactory, destinationType, username, password,
			true);  // force transacted to be true
		XaJmsConnectionPool pool = new XaJmsConnectionPool(poolKey);

		transactions.put(transaction, pool);

		TransactionStrategy tx = TransactionStrategy
			.getTransactionStrategy(true);

		try
		{
		    tx.registerSynchronization(new PoolSynchronization(
			    transactions, pool));
		}
		catch (TransactionStrategyException ex)
		{
		    logger.warn("Problem when enlisting synchronization", ex);

		    throw new ConnectionException(ex);
		}

		return pool;
	    }
	    else
		return connection;
	}
    }

}

class PoolSynchronization implements Synchronization
{
    PoolSynchronization(HashMap<Object, JmsConnectionPool> transactions,
	    XaJmsConnectionPool pool)
    {
	_transactions = transactions;
	_pool = pool;
    }

    public void beforeCompletion ()
    {
    }

    public void afterCompletion (int status) // we don't care about the
                                                // status
    {
	_pool.removeTxSessionPool();
	_pool.terminated();
	
	synchronized (_transactions)
	{
	    _transactions.remove(_pool);
	}
    }

    private HashMap<Object, JmsConnectionPool> _transactions;

    private XaJmsConnectionPool _pool;
}
