package org.jboss.soa.esb.actions.converters;

import java.util.List;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;

/**
 * Abstract object and xstream action processor for common functionality. 
 * 
 * 
 * @author danielmarchant
 *
 */
public abstract class AbstractObjectXStream extends AbstractActionPipelineProcessor {
	
	
	protected String classAlias;
	protected String rootNodeName;
	protected boolean excludePackage = true;
	protected String classMethod;
    protected Class processorClass;
	protected String classProcessor;
	private String name;
		 
	    
    /**
     * Public constructor.
     * @param properties Action Properties.
     * @throws ConfigurationException Action not properly configured.
     */
    protected AbstractObjectXStream(ConfigTree properties) {
    	this( properties.getName(), properties.attributesAsList());
    }
	    
    /**
     * Public constructor.
     * @param actionName Action name.
     * @param properties Action Properties.
     * @throws ConfigurationException Action not properly configured.
     */
    public AbstractObjectXStream(String actionName, List<KeyValuePair> properties) {
    	name = actionName;
    	classAlias = KeyValuePair.getValue("class-alias", properties, null);
        excludePackage = KeyValuePair.getBooleanValue("exclude-package", properties, true);
        rootNodeName = KeyValuePair.getValue("root-node", properties, null );
    }
	
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	

	/**
	 * Gets the alias to use with classes.
	 * 
	 * @param obj
	 * @return String
	 */
	protected String getAlias(Object obj) {
		if(classAlias == null) {
            if(excludePackage) {
                return (obj instanceof Class) ? ((Class)obj).getSimpleName() : obj.getClass().getSimpleName();
            } else {
               return (obj instanceof Class) ? ((Class)obj).getName() : obj.getClass().getName();
            }
        } 
		return classAlias;
	}

	public String getRootNodeName()
	{
		return rootNodeName;
	}

}
