/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.soa.esb.listeners.ha;

import java.util.List;
import java.util.Random;

import org.jboss.soa.esb.addressing.EPR;

/**
 * LoadBalancingPolicy implementation that always fully randomly select its epr
 * (without basing its decision on any historic).
 *
 * Code based on jbossas ha framework.
 *  
 * @author <a href="mailto:kurt@osconsulting.org">Kurt Stam</a>.
 */
public class RandomRobin implements LoadBalancePolicy
{
   private static final long serialVersionUID = 1L;
   /** This needs to be a class variable or else you end up with multiple
    * Random numbers with the same seed when many clients lookup a proxy.
    */
   public static final Random localRandomizer = new Random (System.currentTimeMillis ());
   
   
   public EPR chooseEPR (ServiceClusterInfo serviceCluster)
   {
      List<EPR> eprs = serviceCluster.getEPRs ();
      int max = eprs.size();

      if (max == 0)
         return null;

      int cursor = localRandomizer.nextInt (max);
      return eprs.get(cursor);
   }

}
