/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.routing;

import static org.junit.Assert.fail;
import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class HttpRouterUnitTest
{
	private Logger log = Logger.getLogger( HttpRouterUnitTest.class );
	
	private Message msg = MessageFactory.getInstance().getMessage();
	private ConfigTree tree = new ConfigTree("test");
	
	@Before
	public void setUp()
	{
		msg.getBody().add("hello world".getBytes());
	}
	
	
	@Test ( expected = ActionProcessingException.class )
	public void testRouter_UnknownHost() throws ActionProcessingException
	{
		setRouterURL( "http://foo.bar" );
		HttpRouter router = new HttpRouter(tree);
		log.warn( "The following errors are intentional" );
		router.process(msg);
	}
	
	/**
	 * Should this test really be here? Is this not dependant on a 
	 * running http server...
	 */
	@Test ( timeout=7000, expected = ActionProcessingException.class )
	@Ignore
	public void testRouter_IP_Address() throws ActionProcessingException
	{
		setRouterURL( "http://172.16.127.160:9090" );
		HttpRouter router = new HttpRouter(tree);
		
		Message msg = MessageFactory.getInstance().getMessage();
		
		msg.getBody().add("hello world".getBytes());
		
		boolean exception = false;
		
		try
		{
			router.process(msg);
		}
		catch (ActionProcessingException ex)
		{
			exception = true;
		}
		
		if (!exception)
			fail();
		
		tree.setAttribute(ListenerTagNames.HTTP_ROUTER_ROUTE_URL, "http://172.16.127.160:9090");
		
		router = new HttpRouter(tree);
		
		try
		{
			router.process(msg);
		}
		catch (ActionProcessingException ex)
		{
			//fail();
		}
	}
	
	private void setRouterURL( String url )
	{
		tree.setAttribute(ListenerTagNames.HTTP_ROUTER_ROUTE_URL, url);
	}
	
	public static junit.framework.Test suite() {
		return new JUnit4TestAdapter(HttpRouterUnitTest.class);
	}
	
}
