/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import java.util.zip.ZipOutputStream;

/**
 * ProcessDeployer deploys as a PAR and uses the functionality of DeployProcessToServerTask without requiring the use of ant.
 * 
 * @author kurt stam
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class ProcessDeployer {
    public void execute (String serverName, String serverPort, String serverDeployer, List<File> fileList) throws Exception {
    	ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    	ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
    	DeployProcessToServerTask dptt = new DeployProcessToServerTask();
    	
    	dptt.setServerName(serverName);
    	dptt.setServerPort(serverPort);
    	dptt.setServerDeployer(serverDeployer);
    	
    	for (File file : fileList) {
    		dptt.addFile(zipOutputStream, file);
    	}
    	
    	zipOutputStream.close();
    	
    	dptt.deployProcessWithServlet(serverName, serverPort, serverDeployer, byteArrayOutputStream.toByteArray());
    }   
}
