/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm;


/**
 * 
 * @author <a href="mailto:schifest@heuristica.com.ar">schifest@heuristica.com.ar</a> 
 *
 */
public class Constants {
	
	// 'Well known' names for action configuration
	public static final String BODY_CONTENT_VARIABLE_NAME	="BODY_CONTENT";
	
	// Names to be used as keys both in the ESB message and in the Jbpm context (process & token)
	public static final String COMMAND_CODE					="jbpmCommandCode";

	public static final String PROCESS_DEFINITION			="jbpmProcessDefinition";
	public static final String PROCESS_DEFINITION_XML		="jbpmProcessDefinitionXml";
	public static final String PROCESS_DEFINITION_NAME		="jbpmProcessDefName";
	public static final String PROCESS_DEFINITION_ID		="jbpmProcessDefId";
	public static final String PROCESS_DEFINITION_VERSION	="jbpmProcessDefVersion";
	public static final String PROCESS_INSTANCE_ID			="jbpmProcessInstId";
	public static final String HAS_ENDED					="jbpmObjectEnded";
	public static final String TASK_INSTANCE_ID				="jbpmTaskInstId";
	public static final String TASK_ID_LIST					="jbpmTaskIdList";
	public static final String TOKEN_ID						="jbpmTokenId";
	public static final String CREATE_START_TASK			="jbpmCreateStartTask";
	public static final String INCLUDE_VARIABLES			="jbpmIncludeVariables";
	public static final String INCLUDE_LOGS					="jbpmIncludeLogs";
	public static final String VARIABLE_NAMES_ARRAY			="jbpmVariableNamesArray";
	public static final String ACTOR_ID						="jbpmActorId";
	public static final String ACTOR_NAMES_ARRAY			="jbpmActorNamesArray";
	public static final String OVERWRITE_SWIMLANE			="jbpmOverwriteSwim";
    public static final String KEYPATH                      ="pathTojbpmKey";
    public static final String NODE_ID                      ="jbpmNodeId";
    public static final String PROCESS_NODE_VERSION_COUNTER ="jbpmProcessNodeVersionCounter";

	public static final String TRANSITION_NAME				="jbpmTransitionName";
	public static final String CURRENT_NODE_NAME			="jbpmCurrentNodeName";
	public static final String VARIABLE_VALUES				="jbpmVariableMappings";
	public static final String JBPM_RETURN_OBJECT			="jbpmReturnObject";
	public static final String EXCEPTION     				="jbpmException";
	public static final String ERROR_MESSAGE   				="jbpmErrorMsg";
	public static final String RETURN_CODE					="jbpmReturnCode";
    public static final String JBPM_LOG_MAP                 ="jbpmLogMap";
	
	// Possible values of return codes after execution of an action
	public static final String RETCODE_OK					="jbpmReturnOK";
	public static final String RETCODE_INVALID_OPCODE		="jbpmReturnInvalidOpCode";
	public static final String RETCODE_EXCEPTION			="jbpmReturnExceptionThrown";
	public static final String RETCODE_ERROR				="jbpmReturnError";

	// tag names for xml configuration of actions
	public static final String COMMAND_CODE_TAG				="command";
	public static final String PROCESS_DEFINITION_FILE_TAG	="process-definition-file";
	public static final String PROCESS_DEFINITION_XML_TAG	="process-definition-xml";
	public static final String PROCESS_DEFINITION_NAME_TAG	="process-definition-name";
	public static final String PROCESS_DEFINITION_ID_TAG	="process-definition-id";
	public static final String TRANSITION_NAME_TAG			="transition-name";
	public static final String INCLUDE_ALL_VARS_TAG			="include-all-variables";
	public static final String INCLUDE_LOGS_TAG				="include-logs";
	public static final String VARIABLES_TAG				="variables";
	public static final String ONE_VARIABLE_TAG				="variable";
	public static final String ESB_VARNAME_TAG				="esb";
	public static final String BPM_VARNAME_TAG				="bpm";
    public static final String DEFAULT_VALUE_TAG            ="default";
	public static final String ACTORS_TAG					="actors";
	public static final String ONE_ACTOR_TAG				="actor";
	public static final String OVERWRITE_SWIMLANE_TAG		="overwrite-swimlane";
    public static final String KEY_TAG                      ="key";
    
    //tag names for xml configuration of jBPM actions
    public static final String BPM_TO_ESB_VARS_TAG = "bpmToEsbVars";
    public static final String ESB_TO_BPM_VARS_TAG = "esbToBpmVars";
    public static final String MAPPING_TAG = "mapping";
    public static final String BPM_NAME_ATTR = "bpm";
    public static final String ESB_NAME_ATTR = "esb";
    public static final String PROCESS_SCOPE_ATTR = "process-scope";

	public enum OpCode
	{
        CallbackCommand
//		,DeployProcessDefinition
//		,AbstractCancelCommand
//		,AbstractGetObjectBaseCommand
//		,AsynchronousCommand
		,CancelProcessInstanceCommand
//		,CancelTokenCommand
//		,CancelWorkOnTaskCommand
//		,ChangeProcessInstanceVersionCommand
//		,Command
//		,CommandService
//		,CompositeCommand
//		,GetProcessDefinitionCommand
//		,GetProcessInstanceCommand
//		,GetProcessInstancesCommand
//		,GetTaskInstanceCommand
//		,GetTaskListCommand
		,NewProcessInstanceCommand
		,SignalCommand
		,StartProcessInstanceCommand
//		,StartWorkOnTaskCommand
//		,TaskInstanceEndCommand
//		,VariablesCommand
		;
	}
}
