/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services.jbpm.actionhandlers;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.junit.BeforeClass;
import org.junit.Test;
/**
 * Tests the capabilities of jBPM timer, which we are using.
 * 
 * @author kstam
 *
 */
public class TimerTest 
{
    private static String PROCESS_DEF_XML = "testTimer.xml";
	private static Logger logger = Logger.getLogger(TimerTest.class);
    private static long processInstanceId;
    //private static ProcessInstance processInstance = null;
    //private static JbpmContext jbpmContext = null;
    //private static GraphSession graphSession = null;

    @BeforeClass
    public static void setup() throws Exception
    {
        logger.info("Setting up jBPM");
        JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance();
        
        jbpmConfiguration.getJobExecutor().start();
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        //Extract a process definition from the processdefinition.xml file.
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlResource(PROCESS_DEF_XML);
        assertNotNull(processDefinition);
        //Create an instance of the process definition.
        jbpmContext.deployProcessDefinition(processDefinition);
        ProcessInstance processInstance = jbpmContext.newProcessInstance("testTimer");
        processInstanceId = processInstance.getId();
        assertTrue(
                "Instance is in start state", 
                "start".equals(processInstance.getRootToken().getNode().getName()));
        processInstance.getContextInstance().createVariable("processingTime", "3000");
        jbpmContext.close(); 
    }

    /**
     * Tests timeout functionality of jBPM
     * 
     * @throws Exception
     */
    @Test
    public void timeOut() throws Exception
    { 
        JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance();
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        ProcessInstance processInstance = jbpmContext.loadProcessInstance(processInstanceId);
        
        Token token = processInstance.getRootToken(); 
        processInstance.signal();
        assertEquals("wait1",token.getNode().getName());
        jbpmContext.close();
        
        int seconds=0;
        while (true) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {}
            jbpmContext = jbpmConfiguration.createJbpmContext();
            processInstance = jbpmContext.loadProcessInstance(processInstanceId);
            token = processInstance.getRootToken();
            String currentNode = token.getNode().getName();
            System.out.println(seconds++ + " " + currentNode);
            jbpmContext.close();
            if (currentNode.equals("end")) break;
            if (seconds > 20) break; 
        }
        
        //Check that we are now in the end node.
        assertEquals("end",token.getNode().getName());
    }
    
    public static junit.framework.Test suite(){
        return new JUnit4TestAdapter(TimerTest.class);
    }

}
