/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.routing.cbr;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.message.mapping.ObjectMapper;
import org.jboss.soa.esb.message.mapping.ObjectMappingException;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.junit.Test;

/**
 * 
 * @author kurt.stam@redhat.com
 *
 */
public class BusinessProcessorRoutingUnitTest
{
	@Test
	public void discount() throws ObjectMappingException
	{
        //new messages
		Message message = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
		Order order = new Order();
        order.setQuantity(20);
        order.setUnitPrice(new BigDecimal("20.0"));
		message.getBody().add("Order", order);
        //extract the order from the message, so the drl can process it
        List<String> messagePathList = new ArrayList<String>();
        messagePathList.add("body.Order");
        ObjectMapper mapper = new ObjectMapper();
        List<Object> objectList = mapper.createObjectList(message, messagePathList);
        //Now send to the rules engine
		JBossRulesRouter jbossRulesRouter = new JBossRulesRouter();
        try {
    		List<String> destinations = jbossRulesRouter.route("JBossESBPricingRoutingRules.drl", false, message, objectList);
            assertEquals(order.getDiscount(),10.0);
            assertEquals("10%",message.getBody().get("DiscountObject"));
            String shippingDestination = destinations.iterator().next();
            System.out.println(shippingDestination);
            assertEquals("express-shipping-destination", shippingDestination);
           
        } catch (MessageRouterException mre) {
            System.out.println("Exception was thrown.");
            mre.printStackTrace();
            assertTrue(false);
        }
	}
    
    @Test
    public void nodiscount() throws ObjectMappingException
    {
        //new messages
        Message message = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
        Order order = new Order();
        order.setQuantity(2);
        order.setUnitPrice(new BigDecimal("20.0"));
        message.getBody().add("Order", order);
//      extract the order from the message, so the drl can process it
        List<String> messagePathList = new ArrayList<String>();
        messagePathList.add("body.Order");
        ObjectMapper mapper = new ObjectMapper();
        List<Object> objectList = mapper.createObjectList(message, messagePathList);
        //Now send to the rules engine
        JBossRulesRouter jbossRulesRouter = new JBossRulesRouter();
        try {
            List<String> destinations = jbossRulesRouter.route("JBossESBPricingRoutingRules.drl", false, message, objectList);
            assertEquals(order.getDiscount(),0.0);
            assertEquals("0%",message.getBody().get("DiscountObject"));
            String shippingDestination = destinations.iterator().next();
            System.out.println(shippingDestination);
            assertEquals("normal-shipping-destination", shippingDestination);
           
        } catch (MessageRouterException mre) {
            System.out.println("Exception was thrown.");
            mre.printStackTrace();
            assertTrue(false);
        }
    }
	
	public static junit.framework.Test suite() {
		return new JUnit4TestAdapter(BusinessProcessorRoutingUnitTest.class);
	}

}
