package org.jboss.configapp;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Provides a list of all JBossESB configurations on the server. This includes
 * all *-esb.xml files as well as any *.esb archives and exploded archives.
 * 
 * @author Derek Adams
 */
public class ConfigListServlet extends HttpServlet {

	/** Serial version UID */
	private static final long serialVersionUID = 1L;

	/** Date formatter for XSD date */
	private static SimpleDateFormat FORMATTER = new SimpleDateFormat(
			"yyyy-MM-dd'T'HH:mm:ss");

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		List<File> configs = JBossESBConfigLocator.locateConfigFiles();
		StringBuilder builder = new StringBuilder();
		builder.append("<jbossesb-config-list>\n");
		for (File file : configs) {
			Date lastMod = new Date(file.lastModified());
			builder.append("  <config name=\"" + file.getName()
					+ "\" modified=\"" + FORMATTER.format(lastMod) + "\"/>\n");
		}
		builder.append("</jbossesb-config-list>");
		String xml = builder.toString();

		response.setContentType("application/octet-stream");
		response.setContentLength((int) xml.length());
		response.setHeader("Content-Disposition",
				"attachement; filename=\"config-list.xml\"");

		ServletOutputStream out = response.getOutputStream();
		try {
			out.write(xml.getBytes());
		} finally {
			out.close();
		}
	}
}