package model.providers {
	
	import model.common.Namespaces;
	import model.common.Property;
	
	import mx.collections.ArrayCollection;
	
	/**
	 * A bus on which data from the provider is placed.
	 */
	[Bindable]
	public class Bus {
		
		/** Unique bus id */
		public var id:String;
		
		/** Collection of provider props */
		public var properties:ArrayCollection;
		
		/**
		 * Create a Bus from XML.
		 */
		public function Bus(xml:XML = null) {
			if (xml != null) {
				this.id = xml.@busid;
				this.properties = Property.getProperties(xml);
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			return null;
		}
		
		/**
		 * Get a list of buses from an enclosing element.
		 */
		public static function getBuses(xml:XML):ArrayCollection {
			var results:ArrayCollection = new ArrayCollection();
			for each (var busXml:XML in xml.children()) {
				var tag:String = busXml.localName();
				if (tag == "fs-bus") {
					results.addItem(new FileBus(busXml));					
				} else if (tag == "ftp-bus") {
					results.addItem(new FtpBus(busXml));					
				} else if (tag == "jms-bus") {
					results.addItem(new JmsBus(busXml));					
				}
			}
			return results;
		}
	}
}