package model.providers {
	
	import model.common.Namespaces;
	
	/**
	 * Bus instance for FTP protocol.
	 */
	[Bindable]
	public class FtpBus extends Bus {
		
		/** Filter options for the bus */
		public var filter:FtpMessageFilter = new FtpMessageFilter();
		
		/** Indicates whether the filter should be used */
		public var useFilter:Boolean = true;
		
		/** QName for the providers element */
		private static const FILTER:QName = new QName(Namespaces.JESB, "ftp-message-filter");
		
		/**
		 * Create a FileBus from XML.
		 */
		public function FtpBus(xml:XML = null) {
			super(xml);
			if (xml != null) {
				var filterXml:XMLList = xml.elements(FILTER);
				if (filterXml.length() > 0) {
					this.filter = new FtpMessageFilter(filterXml[0]);
					this.useFilter = true;
				} else {
					this.useFilter = false;
				}
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<ftp-bus ";
			xml = xml + " busid=\"" + this.id + "\" ";
			xml = xml + ">";
			if (useFilter) {
				xml = xml + filter.getXmlString();
			}
			xml = xml + "</ftp-bus>";
			return xml;
		}
	}
}