package model.providers {
	
	import model.common.XmlUtils;
	
	/**
	 * Message filter for an FtpBus
	 */
	[Bindable]
	public class FtpMessageFilter {
		
		/** Filter directory */
		public var directory:String;
		
		/** Filter username */
		public var username:String;
		
		/** Filter password */
		public var password:String;
		
		/** Filter input suffix */
		public var inputSuffix:String;
		
		/** Filter work suffix */
		public var workSuffix:String = ".esbInProcess";
		
		/** Flag for post delete */
		public var postDelete:Boolean = true;
		
		/** Filter post directory */
		public var postDirectory:String = "processed";
		
		/** Filter post suffix */
		public var postSuffix:String = ".esbDone";
		
		/** Flag for error delete */
		public var errorDelete:Boolean = true;
		
		/** Filter error directory */
		public var errorDirectory:String = "processed";
		
		/** Filter error suffix */
		public var errorSuffix:String = ".esbERROR";
		
		/** Flag for passive mode */
		public var passive:Boolean = false;
		
		/** FTP protocol */
		public var protocol:String;
		
		/** URL for certificate */
		public var certificateUrl:String;
		
		/**
		 * Create a FileMessageFilter from XML.
		 */
		public function FtpMessageFilter(xml:XML = null) {
			if (xml != null) {
				this.directory = xml.attribute("directory");
				this.username = xml.attribute("username");
				this.password = xml.attribute("password");
				this.inputSuffix = xml.attribute("input-suffix");
				this.workSuffix = xml.attribute("work-suffix");
				this.postDelete = XmlUtils.asBoolean(xml.attribute("post-delete"), true);
				this.postDirectory = xml.attribute("post-directory");
				this.postSuffix = xml.attribute("post-suffix");
				this.errorDelete = XmlUtils.asBoolean(xml.attribute("error-delete"), true);
				this.errorDirectory = xml.attribute("error-directory");
				this.errorSuffix = xml.attribute("error-suffix");
				this.passive = XmlUtils.asBoolean(xml.attribute("passive"), false);
				this.protocol = xml.attribute("protocol");
				this.certificateUrl = xml.attribute("certificate-url");
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			var xml:String = "<ftp-message-filter ";
			xml = xml + " directory=\"" + this.directory + "\" ";
			xml = xml + " username=\"" + this.username + "\" ";
			xml = xml + " password=\"" + this.password + "\" ";
			xml = xml + " input-suffix=\"" + this.inputSuffix + "\" ";
			if (this.workSuffix.length > 0) {
				xml = xml + " work-suffix=\"" + this.workSuffix + "\" ";
			}
			xml = xml + " post-delete=\"" + this.postDelete + "\" ";
			if (this.postDirectory.length > 0) {
				xml = xml + " post-directory=\"" + this.postDirectory + "\" ";
			}
			if (this.postSuffix.length > 0) {
				xml = xml + " post-suffix=\"" + this.postSuffix + "\" ";
			}
			xml = xml + " error-delete=\"" + this.errorDelete + "\" ";
			if (this.errorDirectory.length > 0) {
				xml = xml + " error-directory=\"" + this.errorDirectory + "\" ";
			}
			if (this.errorSuffix.length > 0) {
				xml = xml + " error-suffix=\"" + this.errorSuffix + "\" ";
			}
			xml = xml + " passive=\"" + this.passive + "\" ";
			xml = xml + " protocol=\"" + this.protocol + "\" ";
			if (this.certificateUrl.length > 0) {
				xml = xml + " certificate-url=\"" + this.certificateUrl + "\" ";
			}
			xml = xml + "/>";
			return xml;
		}
	}
}