<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ page session="true" %>
<%@ page import="
		org.jboss.soa.esb.addressing.EPR,
		org.jboss.soa.esb.couriers.CourierFactory,
		org.jboss.soa.esb.couriers.CourierUtil,		
		org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier,
		org.jboss.soa.esb.listeners.RegistryUtil,
		org.jboss.soa.esb.message.Message,
		org.jboss.soa.esb.message.body.content.MessageBodyTypeNames,
		org.jboss.soa.esb.message.format.MessageFactory,
		java.net.URI,	
		java.util.List,
		java.util.UUID,
		org.hibernate.Session,
		org.hibernate.Transaction,
		org.jboss.soa.esb.monitoring.MonitoringSessionFactory,
		org.jboss.soa.esb.message.body.content.ServiceControlCommand,
		org.jboss.soa.esb.monitoring.pojo.*,
		org.jboss.soa.esb.monitoring.server.FilerAction
"%>
<html>
<head>
   <title>JBoss ESB Monitoring Console</title>
   <link rel="stylesheet" href="style_master.css" type="text/css">
   <meta http-equiv="cache-control" content="no-cache">
</head>
<body>
   <table>
      <tr>
         <td><img src="images/logo.gif" align="left" border="0" alt="JBoss"></td>
         <td valign="middle">         
         <h1>JBoss ESB Management Console</h1>
         </td>
      </tr>
      </table>
      <table cellpadding="5">
      <tr>
      	<td><a href="/jbossesb/">Monitoring</a></td>
      	<td><a href="/jbossesb/results.jsp">View invocation results</a></td>
      </tr>
   </table>
<hr>
<%
String idString = request.getParameter("id");
Long id = new Long(idString);
Session sess = null;
Transaction tx = null;
ServiceControlCommand obean = null;
try {
	sess = MonitoringSessionFactory.getInstance().openSession();
	tx = sess.beginTransaction();
	
	JMXOperation jmxo = (JMXOperation) sess.load(JMXOperation.class, id);
	obean = new ServiceControlCommand(jmxo.getObjectname(), jmxo.getServername(), null, 
			jmxo.getOperation(), jmxo.getDescription(), jmxo.getReturntype());
	obean.setId(id);
	tx.commit();
	
} catch (Exception e) {
	e.printStackTrace();
} finally {
	if (tx.isActive()) {
		tx.rollback();
	} 
	tx = null;
	
	sess.flush();
	sess.close();
	sess = null;
}

List list = RegistryUtil.getEprs(FilerAction.INTERNAL_CATEGORY, FilerAction.INVOKER_SERVICE_ACTION_NAME);
if (list != null) {
	for (int i = 0; i < list.size(); i++) {
		EPR epr = (EPR)list.get(i); 
		Message esbMessage = MessageFactory.getInstance().getMessage();
		esbMessage.getProperties().setProperty(MessageBodyTypeNames.COMMAND_TYPE, MessageBodyTypeNames.INVOKER_REQUEST); 
		esbMessage.getBody().add(obean);
		
	    URI uri = new URI(UUID.randomUUID().toString());
	    esbMessage.getHeader().getCall().setMessageID(uri);

	    DeliverOnlyCourier sender = null;
	    try {
		    sender = CourierFactory.getCourier(epr);
		    sender.deliver(esbMessage);
	    } finally {
	    	CourierUtil.cleanCourier(sender);
	    }
	}
}

RequestDispatcher disp;
disp = getServletContext().getRequestDispatcher("/operations.jsp"); 
disp.forward(request, response);
%>
</html>