/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring.pojo;

import java.util.Date;

/**
 * POJO storing a JMX attribute's data on a specific server at a specific
 * time.   The JMXData object stores the related attribute, the server name,
 * the collection date and the data.    Only one of the
 * timevalue/countvalue/textvalue are set - depending on what the type of the
 * object is.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class JMXData  implements java.io.Serializable {

	private static final long serialVersionUID = -1862113692118964270L;
	private Long id;
	private JMXAttribute attribute;
	private String server;
	private Date statdate;
	private Float timevalue;
	private Integer countvalue;
	private String textvalue;

    /**
     * Constructor.
     */
    public JMXData() {
    }

    /**
     * Constructor.
     * @param attribute attribute
     * @param server server name 
     * @param statdate statistic date
     * @param timevalue time value
     * @param countvalue count value 
     * @param textvalue test value
     */
    public JMXData(JMXAttribute attribute, String server, Date statdate, Float timevalue, Integer countvalue, String textvalue) {
       this.attribute = attribute;
       this.server = server;
       this.statdate = statdate;
       this.timevalue = timevalue;
       this.countvalue = countvalue;
       this.textvalue = textvalue;
    }
   
    /**
     * Id getter.
     * @return id
     */
    public Long getId() {
        return this.id;
    }
    
    /**
     * Id mutator. 
     * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }
    
    /**
     * Attribute name getter.
     * @return attribute name
     */
    public JMXAttribute getAttribute() {
        return this.attribute;
    }
    
    /**
     * Attribute name mutator.
     * @param attribute attribute name
     */
    public void setAttribute(JMXAttribute attribute) {
        this.attribute = attribute;
    }
    
    /**
     * Server name getter.
     * @return server name
     */
    public String getServer() {
    	return server;
    }
    
    /**
     * Server name mutator.
     * @param f_server server name
     */
    public void setServer(String f_server) {
    	server = f_server;
    }
    
    /**
     * Stat date getter.
     * @return stat date
     */
    public Date getStatdate() {
        return this.statdate;
    }
    
    /**
     * Stat date mutator.
     * @param statdate stat date
     */
    public void setStatdate(Date statdate) {
        this.statdate = statdate;
    }
    
    /**
     * Time value getter.
     * @return time value
     */
    public Float getTimevalue() {
        return this.timevalue;
    }
    
    /**
     * Time value mutator.
     * @param timevalue time value
     */
    public void setTimevalue(Float timevalue) {
        this.timevalue = timevalue;
    }
    
    /**
     * Count value getter.
     * @return count value
     */
    public Integer getCountvalue() {
        return this.countvalue;
    }
    
    /**
     * Count value mutator.
     * @param countvalue count value
     */
    public void setCountvalue(Integer countvalue) {
        this.countvalue = countvalue;
    }
    
    /**
     * Text value getter.
     * @return text value
     */
    public String getTextvalue() {
        return this.textvalue;
    }
    
    /**
     * Text value mutator.
     * @param textvalue text value
     */
    public void setTextvalue(String textvalue) {
        this.textvalue = textvalue;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
    	return "id [" + id + "] time[" + statdate + "] server [" 
    		+ server + "] attribute [" + attribute.getId() + " " + attribute.getObjectname() 
    		+ "] count[" + countvalue + "] text [" + textvalue + "] timevalue [" + timevalue + "]";
    }

}


