/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring.pojo;

/**
 * POJO that stores information on the ObjectNames that will be queried
 * for JMX attribute information.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class JMXPattern  implements java.io.Serializable {

	private static final long serialVersionUID = 5166687617223133915L;
	private Long id;
	private String classpattern;
	private String keyvalue;

    /**
     * Constructor
     */
    public JMXPattern() {
    }

    /**
     * Constructor that takes in a pattern to query JMX with and
     * a filter to find the ObjectNames with ESB metrics.
     * @param classpattern class pattern
     * @param keyvalue key value
     */
    public JMXPattern(String classpattern, String keyvalue) {
       this.classpattern = classpattern;
       this.keyvalue = keyvalue;
    }
   
    /**
     * Id getter.
     * @return id
     */
    public Long getId() {
        return this.id;
    }
    
    /**
     * Id mutator
     * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }
    
    /**
     * Class pattern getter.
     * @return class pattern
     */
    public String getClasspattern() {
        return this.classpattern;
    }
    
    /**
     * Class pattern mutator.
     * @param classpattern class pattern
     */
    public void setClasspattern(String classpattern) {
        this.classpattern = classpattern;
    }
    
    /**
     * Getter for the filter that finds ObjectNames for metric collection.
     * @return
     */
    public String getKeyvalue() {
        return this.keyvalue;
    }
    
    /**
     * Mutator for the filter that finds ObjectNames for metric collection.
     * @param keyvalue key value
     */
    public void setKeyvalue(String keyvalue) {
        this.keyvalue = keyvalue;
    }
}