delete from participant;
delete from messagecontract;
delete from transformationresourceparameter;
delete from transformationresource;
delete from transformationresourceparameterspec;
delete from transformationresourcespec;

--########################################################################
--#  Sample Message Exchange Participants.
--########################################################################
INSERT INTO participant (id, name) VALUES (1, 'DVDStore:OrderDispatchService');
INSERT INTO participant (id, name) VALUES (2, 'DVDWarehouse_1:OrderHandlingService');
INSERT INTO participant (id, name) VALUES (3, 'DVDWarehouse_2:OrderHandlingService');
INSERT INTO participant (id, name) VALUES (4, 'DataWarehouse:OrderTrackingService');

--########################################################################
--#  Sample Message Contracts.
--########################################################################
INSERT INTO messagecontract (id, participant, usage, mime, namespace, messagedescription) VALUES (1, 'DVDStore:OrderDispatchService', 'PRODUCES', 'text/xml', 'fullFillOrder', 'http://org.acme/OrderDispatchService/fullFillOrder.xsd');
INSERT INTO messagecontract (id, participant, usage, mime, namespace, messagedescription) VALUES (2, 'DVDWarehouse_1:OrderHandlingService', 'CONSUMES', 'text/xml', 'shipOrder', 'http://org.acme/OrderHandlingService/shipOrder-post.dtd');
INSERT INTO messagecontract (id, participant, usage, mime, namespace, messagedescription) VALUES (3, 'DVDWarehouse_2:OrderNotificationService', 'CONSUMES', 'application/EDI-X12', 'notifyCustomer', 'http://org.acme/OrderHandlingService/notifyCustomer.xsd');
INSERT INTO messagecontract (id, participant, usage, mime, namespace, messagedescription) VALUES (4, 'DataWarehouse:OrderTrackingService', 'CONSUMES', 'text/xml', 'recordOrder', 'http://org.acme/OrderTrackingService/recordOrder.xsd');

--########################################################################
--#  Templating cdu-creators.
--########################################################################
insert into transformationresource (id, name, path, selector, useragent) values (1, '* XSLT Content Delivery Unit Creator (This resource is targeted at all Message Exchanges and is required for interpreting "xsl" resource types)', 'org.milyn.templating.xslt.XslContentDeliveryUnitCreator', 'cdu-creator', '*');
insert into transformationresourceparameter (id, name, value, transresource_id) values (1, 'restype', 'xsl', 1);

insert into transformationresource (id, name, path, selector, useragent) values (2, '* StringTemplate Content Delivery Unit Creator (This resource is targeted at all Message Exchanges and is required for interpreting "st" resource types)', 'org.milyn.templating.stringtemplate.StringTemplateContentDeliveryUnitCreator', 'cdu-creator', '*');
insert into transformationresourceparameter (id, name, value, transresource_id) values (2, 'restype', 'st', 2);

insert into transformationresource (id, name, path, selector, useragent) values (3, '* Groovy Content Delivery Unit Creator (This resource is targeted at all Message Exchanges and is required for interpreting "groovy" resource types)', 'org.milyn.smooks.scripting.GroovyContentDeliveryUnitCreator', 'cdu-creator', '*');
insert into transformationresourceparameter (id, name, value, transresource_id) values (3, 'restype', 'groovy', 3);

--########################################################################
--#  XSLT Templatelet Resource Template.
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (1, 'XSLT (Templatelet)', 'See ''resdata'' parameter value', 'Perform an XML Fragment Transform using an XSLT Templatelet.  The targeted XML fragment is transformed using the XSLT Templatelet and the transformation result is used in accordance with the value of the "action" parameter.  Can be used in conjunction with the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Javabean Cartridge</a> Cartridge.  <p/>Examples of using this resource can be seen on the <a href="http://milyn.codehaus.org/Tutorials">Milyn Smooks</a> website.<p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Templating Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/templating/org/milyn/templating/xslt/XslContentDeliveryUnitCreator.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (1, 'resdata', '', 'Resource Data.  The XSLT Templatelet code.  Just define the body of the xsl <template> - no need for the outer &lt;stylesheet&gt; or &lt;template&gt; tags.', true, 1);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (2, 'action', '', 'Action to be performed with the transformation result relative to the targeted XML Fragment.  Possible values: "replace", "addto", "insertbefore", "insertafter".', true, 1);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (3, 'restype', 'xsl', 'Resource Type.', false, 1);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (4, 'is-xslt-templatelet', 'true', 'Is this XSLT resource an XSLT Templatelet.', false, 1);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (5, 'visitBefore', 'false', 'Should the template be applied before (true) or after (false) Smooks visits the child elements of the target element.', false, 1);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (6, 'encoding', 'UTF-8', 'XSLT Character Encoding.', false, 1);

--########################################################################
--#  StringTemplate Resource Template.
--########################################################################
insert into transformationresourcespec (id, name, description, reference) values (2, 'StringTemplate', 'Perform an XML Fragment Transform using an <a href="http://www.stringtemplate.org">StringTemplate</a> Template.  The targeted XML fragment is transformed using the <a href="http://www.stringtemplate.org">StringTemplate</a> Template and the transformation result is used in accordance with the value of the "action" parameter.  Used in conjunction with the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Javabean Cartridge</a>.  <p/>Examples of using this resource can be seen on the <a href="http://milyn.codehaus.org/Tutorials">Milyn Smooks</a> website.<p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Templating and Javabean Cartridges</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/templating/org/milyn/templating/stringtemplate/StringTemplateContentDeliveryUnitCreator.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (7, 'action', '', 'Action to be performed with the transformation result relative to the targeted XML Fragment.  Possible values: "replace", "addto", "insertbefore", "insertafter".', true, 2);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (8, 'visitBefore', 'false', 'Should the template be applied before (true) or after (false) Smooks visits the child elements of the target element.', false, 2);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (9, 'encoding', 'UTF-8', 'XSLT Character Encoding.', false, 2);

--########################################################################
--#  CSV Message Parser Template.
--########################################################################
insert into transformationresourcespec (id, name, path, selector, description, reference) values (3, 'CSV Message Parser', 'org.milyn.csv.CSVParser', 'org.xml.sax.driver', 'Set the SAX Parser for a Comma Separated Value (CSV) message.  This resource sets the Smooks SAX Parser for the targeted CSV message, allowing the CSV message to be interpretted as an XML DOM.  <p/>Examples of using this resource can be seen on the <a href="http://milyn.codehaus.org/Tutorials">Milyn Smooks</a> website.<p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks CSV Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/csv/org/milyn/csv/CSVParser.html');
insert into transformationresourceparameterspec (id, name, value, param_type, description, required, resourcespec_id) values (10, 'fields', '', 'string-list', 'Comma Separated list of field names that map to the CSV fields expected in the message.  This field names are mapped to the element names in the DOM produced by this parser.  See Reference docs.', true, 3);

--########################################################################
--#  Message Exchange Parameter
--########################################################################
insert into transformationresourcespec (id, name, path, selector, description, reference) values (4, 'Message Exchange Parameter', 'N/A', 'device-parameters', 'Set a Message Exchange specific parameter/property value.  This parameter value will be accessible to all <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/ElementVisitor.html">ElementVisitor</a> derived resource instances via the <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/cdr/ParameterAccessor.html">ParameterAccessor</a> class.  This allows you to configure parameters that cut across message profiles.', 	'http://milyn.codehaus.org/javadoc/smooks/org/milyn/cdr/ParameterAccessor.html');
insert into transformationresourceparameterspec (id, value, description, required, resourcespec_id) values (11, '', 'Parameter Name and Value.', false, 4);

--########################################################################
--#  JavaBean Populators
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (5, 'JavaBean Create - Assembly Phase', 'org.milyn.javabean.AssemblyPhaseBeanPopulator', 'Create a JavaBean instance for population with data from an XML message during the message processing <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/SmooksXML.html">Assembly Phase</a>.  The populated beans can be used in XSLT and StringTemplate transformation (see <a href="http://milyn.codehaus.org/Tutorials">Smooks Templating Tutorials</a>).  The populated beans <a href="http://java.sun.com/j2se/1.4.2/docs/api/java/util/HashMap.html">HasMap</a> is also set on the Message Body (key="EXTRACTED_BEANS_HASH"), allowing them to be accessed by downstream action processors.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AbstractBeanPopulator.html');
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (12, 'beanId', 'Bean Identifier.', true, 5);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (13, 'beanClass', 'Bean Class Name (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 5);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (14, 'addToList', 'Accumulate multiple bean instances (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 5);

insert into transformationresourcespec (id, name, path, description, reference) values (6, 'JavaBean Create - Processing Phase', 'org.milyn.javabean.ProcessingPhaseBeanPopulator', 'Create a JavaBean instance for population with data from an XML message during the message processing <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/SmooksXML.html">Processing Phase</a>.  The populated beans can be used in XSLT and StringTemplate transformation (see <a href="http://milyn.codehaus.org/Tutorials">Smooks Templating Tutorials</a>).  The populated beans <a href="http://java.sun.com/j2se/1.4.2/docs/api/java/util/HashMap.html">HasMap</a> is also set on the Message Body (key="EXTRACTED_BEANS_HASH"), allowing them to be accessed by downstream action processors.', 	'http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AbstractBeanPopulator.html');
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (15, 'beanId', 'Bean Identifier.', true, 6);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (16, 'beanClass', 'Bean Class Name (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 6);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (17, 'addToList', 'Accumulate multiple bean instances (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 6);

insert into transformationresourcespec (id, name, path, description, reference) values (7, 'JavaBean Populate - Assembly Phase', 'org.milyn.javabean.AssemblyPhaseBeanPopulator', 'Populate a JavaBean instance with data from an XML message during the message processing <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/SmooksXML.html">Assembly Phase</a>.  The populated beans can be used in XSLT and StringTemplate transformation (see <a href="http://milyn.codehaus.org/Tutorials">Smooks Templating Tutorials</a>).  The populated beans <a href="http://java.sun.com/j2se/1.4.2/docs/api/java/util/HashMap.html">HasMap</a> is also set on the Message Body (key="EXTRACTED_BEANS_HASH"), allowing them to be accessed by downstream action processors.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AbstractBeanPopulator.html');
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (18, 'beanId', 'Bean Identifier.', true, 7);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (19, 'setterName', 'Explicitly specify the bean setter method name (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 7);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (20, 'attributeName', 'DOM Element attribute name - for extracting a value from a DOM Element attribute (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 7);

insert into transformationresourcespec (id, name, path, description, reference) values (8, 'JavaBean Populate - Processing Phase', 'org.milyn.javabean.ProcessingPhaseBeanPopulator', 'Populate a JavaBean instance with data from an XML message during the message processing <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/SmooksXML.html">Processing Phase</a>.  The populated beans can be used in XSLT and StringTemplate transformation (see <a href="http://milyn.codehaus.org/Tutorials">Smooks Templating Tutorials</a>).  The populated beans <a href="http://java.sun.com/j2se/1.4.2/docs/api/java/util/HashMap.html">HasMap</a> is also set on the Message Body (key="EXTRACTED_BEANS_HASH"), allowing them to be accessed by downstream action processors.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AbstractBeanPopulator.html');
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (21, 'beanId', 'Bean Identifier.', true, 8);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (22, 'setterName', 'Explicitly specify the bean setter method name (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 8);
insert into transformationresourceparameterspec (id, name, description, required, resourcespec_id) values (23, 'attributeName', 'DOM Element attribute name - for extracting a value from a DOM Element attribute (see <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/javabean/org/milyn/javabean/AssemblyPhaseBeanPopulator.html">Javadoc</a>).', false, 8);

--########################################################################
--#  XSLT Stylesheet Resource Template (inlined).
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (9, 'XSLT (Full Stylesheet - Inlined)', 'See ''resdata'' parameter value', 'Perform an XML Fragment Transform using a fully XSLT Stylesheet, specified inline (as opposed to externally).  The targeted XML fragment is transformed using the XSLT Stylesheet and the transformation result is used in accordance with the value of the "action" parameter.  Can be used in conjunction with the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Javabean Cartridge</a> Cartridge.  <p/>Examples of using this resource can be seen on the <a href="http://milyn.codehaus.org/Tutorials">Milyn Smooks</a> website.<p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Templating Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/templating/org/milyn/templating/xslt/XslContentDeliveryUnitCreator.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (24, 'resdata', '', 'Resource Data.  The XSLT Stylesheet.', true, 9);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (25, 'action', '', 'Action to be performed with the transformation result relative to the targeted XML Fragment.  Possible values: "replace", "addto", "insertbefore", "insertafter".', true, 9);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (26, 'restype', 'xsl', 'Resource Type.', false, 9);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (27, 'is-xslt-templatelet', 'false', 'Is this XSLT resource an XSLT Templatelet.', false, 9);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (28, 'visitBefore', 'false', 'Should the template be applied before (true) or after (false) Smooks visits the child elements of the target element.', false, 9);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (29, 'encoding', 'UTF-8', 'XSLT Character Encoding.', false, 9);

--########################################################################
--#  Rename Element.
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (10, 'Rename Element', 'org.milyn.cdres.trans.RenameElementTU', 'Rename Element.<br/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Misc Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/misc/org/milyn/cdres/trans/RenameElementTU.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (30, 'replacementElement', '', 'New name for the element.', true, 10);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (31, 'keepChildContent', '', 'Copy the target element child content to the replacement element.<br/>Default is "true".', false, 10);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (32, 'keepAttributes', '', 'Copy the target element attributes to the replacement element.<br/>Default is "true".', false, 10);

--########################################################################
--#  Set Attribute.
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (11, 'Set Attribute', 'org.milyn.cdres.trans.SetAttributeTU', 'Set Element Attribute.  Allows you add/overwrite an attribute on the target Element.<br/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Misc Cartridge</a> to be installed.','http://milyn.codehaus.org/javadoc/smooks-cartridges/misc/org/milyn/cdres/trans/SetAttributeTU.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (33, 'attributeName', '', 'New attribute name.', true, 11);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (34, 'attributeValue', '', 'Attribute Value.', true, 11);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (35, 'overwrite', '', 'Overwrite existing attributes of the same name.<br/>Default is "false".', false, 11);

--########################################################################
--#  Remove Element.
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (12, 'Remove Element', 'org.milyn.cdres.trans.RemoveElementTU', 'Remove Element.<br/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Misc Cartridge</a> to be installed.','http://milyn.codehaus.org/javadoc/smooks-cartridges/misc/org/milyn/cdres/trans/RemoveElementTU.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (36, 'keepChildContent', '', 'Keep the target element''s child content.<br/>Default is "true".', false, 12);

--########################################################################
--#  Remove Attribute.
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (13, 'Remove Attribute', 'org.milyn.cdres.trans.RemoveAttributeTU', 'Remove an attribute from the target element.<br/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Misc Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/misc/org/milyn/cdres/trans/RemoveAttributeTU.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (37, 'attributeName', '', 'The name of the attribute to be removed from the target element.', true, 13);

--########################################################################
--#  XSLT Stylesheet Resource Template (external).
--########################################################################
insert into transformationresourcespec (id, name, description, reference) values (14, 'XSLT (Full Stylesheet - External)', 'Perform an XML Fragment Transform using a fully XSLT Stylesheet, specified external (by <a href="http://milyn.codehaus.org/javadoc/commons/org/milyn/resource/URIResourceLocator.html">URI reference</a>).  The targeted XML fragment is transformed using the XSLT Stylesheet and the transformation result is used in accordance with the value of the "action" parameter.  Can be used in conjunction with the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Javabean Cartridge</a> Cartridge.  <p/>Examples of using this resource can be seen on the <a href="http://milyn.codehaus.org/Tutorials">Milyn Smooks</a> website.<p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Templating Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/templating/org/milyn/templating/xslt/XslContentDeliveryUnitCreator.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (38, 'action', '', 'Action to be performed with the transformation result relative to the targeted XML Fragment.  Possible values: "replace", "addto", "insertbefore", "insertafter".', true, 14);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (39, 'restype', 'xsl', 'Resource Type.', false, 14);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (40, 'is-xslt-templatelet', 'false', 'Is this XSLT resource an XSLT Templatelet.', false, 14);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (41, 'visitBefore', 'false', 'Should the template be applied before (true) or after (false) Smooks visits the child elements of the target element.', false, 14);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (42, 'encoding', 'UTF-8', 'XSLT Character Encoding.', false, 14);

--########################################################################
--#  Groovy Script Resource Template (inlined).
--########################################################################
insert into transformationresourcespec (id, name, path, description, reference) values (15, 'Groovy Script (Inlined)', 'See ''resdata'' parameter value', 'Perform an XML Fragment Transform using a <a href="http://groovy.codehaus.org">Groovy Script</a>, specified inline (as opposed to externally).<p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Scripting Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/scripting/org/milyn/smooks/scripting/GroovyContentDeliveryUnitCreator.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (43, 'restype', 'groovy', 'Resource Type.', false, 15);
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (44, 'resdata', '', 'Resource Data.  The inlined Groovy script.  The Groovy script class must implement one of <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/assemble/AssemblyUnit.html">AssemblyUnit</a>, <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/process/ProcessingUnit.html">ProcessingUnit</a>, or <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/serialize/SerializationUnit.html">SerializationUnit</a>', true, 15);

--########################################################################
--#  Groovy Script Resource Template (external).
--########################################################################
insert into transformationresourcespec (id, name, description, reference) values (16, 'Groovy Script (External)', 'Perform an XML Fragment Transform using a <a href="http://groovy.codehaus.org">Groovy Script</a>, specified externaly (by <a href="http://milyn.codehaus.org/javadoc/commons/org/milyn/resource/URIResourceLocator.html">URI reference</a>).<p/>The Groovy script class must implement one of <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/assemble/AssemblyUnit.html">AssemblyUnit</a>, <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/process/ProcessingUnit.html">ProcessingUnit</a>, or <a href="http://milyn.codehaus.org/javadoc/smooks/org/milyn/delivery/serialize/SerializationUnit.html">SerializationUnit</a>.<p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks Scripting Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/scripting/org/milyn/smooks/scripting/GroovyContentDeliveryUnitCreator.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (45, 'restype', 'groovy', 'Resource Type.', false, 16);
insert into transformationresourceparameterspec (id, value, description, required, resourcespec_id) values (46, '', 'Optional script specific parameter.', false, 16);

--########################################################################
--#  EDI Message Parser Template.
--########################################################################
insert into transformationresourcespec (id, name, path, selector, description, reference) values (17, 'EDI Message Parser', 'org.milyn.smooks.edi.SmooksEDIParser', 'org.xml.sax.driver', 'Set the SAX Parser for an EDI message.  This resource sets the Smooks SAX Parser for the targeted EDI message, allowing the EDI message to be interpretted as an XML DOM.  <p/>Resources derived from this template will require the <a href="http://milyn.codehaus.org/Smooks#Smooks-smookscartridges">Smooks EDI Cartridge</a> to be installed.', 'http://milyn.codehaus.org/javadoc/smooks-cartridges/edi/org/milyn/smooks/edi/SmooksEDIParser.html');
insert into transformationresourceparameterspec (id, name, value, description, required, resourcespec_id) values (47, 'mapping-model', '', 'EDI to SAX/XML mapping model.  <a href="http://milyn.codehaus.org/javadoc/smooks-cartridges/edi/org/milyn/smooks/edi/SmooksEDIParser.html">See Reference docs</a>.', true, 17);
