/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006
 */
package org.jboss.soa.esb.admin.console.exchange;

import java.util.List;

import javax.ejb.Local;
import javax.ejb.Remove;
import javax.faces.model.SelectItem;

import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.WebRemote;
import org.jboss.soa.esb.admin.console.contract.MessageContract;
import org.jboss.soa.esb.admin.console.contract.MessageContractDTO;
import org.jboss.soa.esb.admin.console.exchange.participant.Participant;

/**
 * SelectMessageExchange action listener interface.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Local
public interface SelectMessageExchange {

	/**
	 * Select the "from" {@link Participant} action listener remote method.
	 * @return The list of "produce" message contracts supported by the selected
	 * participant.
	 */
	@WebRemote
	public List<MessageContractDTO> selectFrom(String selectionId);

	/**
	 * Select the "from" {@link MessageContract} action listener method.
	 */
	@WebRemote
	public void selectFromContract(String selectionId);

	/**
	 * Select the "to" {@link Participant} action listener remote method.
	 * @return The list of "consume" message contracts supported by the selected
	 * participant.
	 */
	@WebRemote
	public List<MessageContractDTO> selectTo(String selectionId);

	/**
	 * Select the "to" {@link MessageContract} action listener method.
	 */
	@WebRemote
	public void selectToContract(String selectionId);

	@Create
	public void initialise();

	public String showFrom();

	public String showFinish();

	public String finish();

	public String home();

	@Remove
	@Destroy
	public void destroy();

	public List<SelectItem> getParticipantListItems();

	public List<Participant> getParticipants();

	public void setParticipants(List<Participant> participants);
}