/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform.flow;

import static org.testng.AssertJUnit.assertEquals;

import org.jboss.soa.esb.admin.console.contract.MessageContract;
import org.jboss.soa.esb.admin.console.exchange.MessageExchange;
import org.jboss.soa.esb.admin.console.exchange.participant.Participant;
import org.testng.annotations.Test;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MessageContractTest {

	@Test
	public void test_getExchangeUseragentString_and_getExchangeUseragentStringAsHtml_getExchangeAsHtml() {
		MessageExchange flow = new MessageExchange();
		
		flow.setFrom(new Participant("jms://x.y"));
		flow.setFromMessageType(new MessageContract("text/xml", null, null));
		flow.setTo(new Participant("file://x.y"));
		flow.setToMessageType(new MessageContract("text/xml", null, null));
		
		assertEquals("from-type:text/xml AND from:jms://x.y AND to-type:text/xml AND to:file://x.y", flow.getExchangeUseragentString());
		assertEquals("<b>from-type:</b>text/xml<br/>AND<br/><b>from:</b>jms://x.y<br/>AND<br/><b>to-type:</b>text/xml<br/>AND<br/><b>to:</b>file://x.y", flow.getExchangeUseragentStringAsHtml());
		assertEquals("<b>from-type:</b> text/xml<br/><b>from:</b> jms://x.y<br/><b>to-type:</b> text/xml<br/><b>to:</b> file://x.y", flow.getExchangeAsHtml());

		flow.setTo(null);
		assertEquals("from-type:text/xml AND from:jms://x.y AND to-type:text/xml", flow.getExchangeUseragentString());
		assertEquals("<b>from-type:</b>text/xml<br/>AND<br/><b>from:</b>jms://x.y<br/>AND<br/><b>to-type:</b>text/xml<br/>AND<br/><b>to:</b>*", flow.getExchangeUseragentStringAsHtml());
		assertEquals("<b>from-type:</b> text/xml<br/><b>from:</b> jms://x.y<br/><b>to-type:</b> text/xml<br/><b>to:</b> *", flow.getExchangeAsHtml());

		flow.setToMessageType(null);
		assertEquals("from-type:text/xml AND from:jms://x.y", flow.getExchangeUseragentString());
		assertEquals("<b>from-type:</b>text/xml<br/>AND<br/><b>from:</b>jms://x.y<br/>AND<br/><b>to-type:</b>*<br/>AND<br/><b>to:</b>*", flow.getExchangeUseragentStringAsHtml());
		assertEquals("<b>from-type:</b> text/xml<br/><b>from:</b> jms://x.y<br/><b>to-type:</b> *<br/><b>to:</b> *", flow.getExchangeAsHtml());
		
		flow.setFrom(null);
		assertEquals("from-type:text/xml", flow.getExchangeUseragentString());
		assertEquals("<b>from-type:</b>text/xml<br/>AND<br/><b>from:</b>*<br/>AND<br/><b>to-type:</b>*<br/>AND<br/><b>to:</b>*", flow.getExchangeUseragentStringAsHtml());
		assertEquals("<b>from-type:</b> text/xml<br/><b>from:</b> *<br/><b>to-type:</b> *<br/><b>to:</b> *", flow.getExchangeAsHtml());

		flow.setFromMessageType(null);
		assertEquals("*", flow.getExchangeUseragentString());
		assertEquals("All Messages", flow.getExchangeUseragentStringAsHtml());
	}
}
