/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.epr;

import junit.framework.Test;
import org.jboss.soa.esb.TestUtils;
import org.jboss.soa.esb.addressing.eprs.LogicalEPR;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.testutils.FileUtil;
import org.jboss.soa.esb.testutils.JMSUtil;
import org.jboss.soa.esb.util.DeploymentArchive;
import org.jboss.test.JBossTestCase;

import java.io.File;
import java.io.FileInputStream;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class LogicalEPRUnitTest extends JBossTestCase {

    private static final String FILE_NAME = "LogicalEPRUnitTest.log";
    private static final File TEST_OUTPUT_FILE = new File(TestUtils.getTempDir(FILE_NAME) + FILE_NAME);

    public LogicalEPRUnitTest(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        TEST_OUTPUT_FILE.delete();
    }

    public void test_replyto() throws Exception {
        // Send the message and wait for the drop...
        JMSUtil.sendMessageToQueue("reply-To", "queue/LogicalEPRUnitTest_service1_gtw", null);
        assertTrue("Test output file '" + TEST_OUTPUT_FILE + "' not dropped.", TestUtils.waitForFile(TEST_OUTPUT_FILE.getAbsolutePath()));

        String actualOutput = FileUtil.readStream(new FileInputStream(TEST_OUTPUT_FILE));
        assertEquals("Reply-To Service3", actualOutput);
    }

    public void test_faultto() throws Exception {
        // Send the message and wait for the drop...
        JMSUtil.sendMessageToQueue("fault-To", "queue/LogicalEPRUnitTest_service1_gtw", null);
        assertTrue("Test output file '" + TEST_OUTPUT_FILE + "' not dropped.", TestUtils.waitForFile(TEST_OUTPUT_FILE.getAbsolutePath()));

        String actualOutput = FileUtil.readStream(new FileInputStream(TEST_OUTPUT_FILE));
        assertEquals("org.jboss.soa.esb.actions.ActionProcessingException: Service2Action fault", actualOutput);
    }

    public void test_logical_extension() throws Exception {
        final LogicalEPR logicalEPR = new LogicalEPR("MyServiceCategory", "MyService4") ;
        final String tag = "TestTag" ;
        final String prefix = "TestPrefix" ;
        final String value = "TestValue" ;
        
        logicalEPR.getAddr().addExtension(tag, prefix, Service4Action.TEST_URI, value) ;
        
        final Message message = MessageFactory.getInstance().getMessage() ;
        message.getBody().add("Incoming Test Payload") ;
        logicalEPR.getServiceInvoker().deliverAsync(message) ;
        
        assertTrue("Test output file '" + TEST_OUTPUT_FILE + "' not dropped.", TestUtils.waitForFile(TEST_OUTPUT_FILE.getAbsolutePath()));

        final String actualOutput = FileUtil.readStream(new FileInputStream(TEST_OUTPUT_FILE));
        final String expectedOutput = "Prefix " + prefix + " Tag " + tag + " value " + value ;
        assertEquals(expectedOutput, actualOutput);
    }

    public static Test suite() throws Exception {
        DeploymentArchive deployment = new DeploymentArchive("LogicalEPRUnitTest.esb");

        deployment.addEntry("META-INF/jboss-esb.xml", LogicalEPRUnitTest.class.getResourceAsStream("jboss-esb.xml"));
        deployment.addEntry("META-INF/deployment.xml", LogicalEPRUnitTest.class.getResourceAsStream("deployment.xml"));
        deployment.addEntry("jms-service.xml", LogicalEPRUnitTest.class.getResourceAsStream("jms-service.xml"));
        deployment.addEntry(ServiceInvokerAction.class);
        deployment.addEntry(Service2Action.class);
        deployment.addEntry(Service3Action1.class);
        deployment.addEntry(Service3Action2.class);
        deployment.addEntry(Service4Action.class);

        deployment.create();

        return getDeploySetup(LogicalEPRUnitTest.class, "LogicalEPRUnitTest.esb");
    }
}
