/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.soa.esb.server;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.management.ObjectName;
import javax.naming.InitialContext;

import junit.framework.Test;

import org.jboss.test.JBossTestCase;

/**
 * Sample client for the jboss container.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Id: BlobUnitTestCase.java 58110 2006-11-04 08:34:21Z scott.stark@jboss.org $
 */

public class SimpleDeployUnitTest
        extends JBossTestCase
{
   org.jboss.logging.Logger log = getLog();

   static boolean deployed = false;
   static int test = 0;

   public SimpleDeployUnitTest(String name)
   {
      super(name);
   }

   public void sendAMessage(String msg, String destination) throws Exception
   {

      InitialContext iniCtx = getInitialContext();
      Object tmp = iniCtx.lookup("ConnectionFactory");
      ConnectionFactory qcf = (ConnectionFactory) tmp;
      Connection conn = qcf.createConnection();
      Destination que = (Queue) iniCtx.lookup(destination);
      Session session = conn.createSession(false, QueueSession.AUTO_ACKNOWLEDGE);
      conn.start();
      MessageProducer send = session.createProducer(que);
      ObjectMessage tm = session.createObjectMessage(msg);
      send.send(tm);
      send.close();
      conn.close();
   }

   public void testSimple() throws Exception
   {
      sendAMessage("Hello World", "queue/esb_gateway_channel");
      Thread.sleep(2000); // wait for message to post.
      String version = (String)getServer().getAttribute(new ObjectName(StatsMBean.objectName), "ExecutedVersion");
      assertEquals("scope1", version);
      
   }

   public void testScope() throws Exception
   {
      sendAMessage("Hello World", "queue/esb_gateway_channel_versioned");
      Thread.sleep(2000); // wait for message to post.
      String version = (String)getServer().getAttribute(new ObjectName(StatsMBean.objectName), "ExecutedVersion");
      assertEquals("scope2", version);

   }
   public static Test suite() throws Exception
   {
       return getDeploySetup(SimpleDeployUnitTest.class, "simple.esb,simple-scoped.esb");
   }

}
