/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.funcbr.test.SendJMSMessage;


/**
 * CI test for the funcbr quickstart.
 *
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @author <a href="mailto:ldimaggi@redhat.com">Len Dimaggio</a>
 */
public class FunCBRTest
        extends AbstractQuickstartTestCase {

	private static String theXML = "<Order orderId=\"1\" "
			+ "orderDate=\"Wed Nov 15 13:45:28 EST 2006\" "
			+ "statusCode=\"0\"  " + "netAmount=\"59.97\" "
			+ "totalAmount=\"64.92\" " + "tax=\"4.95\" "
			+ "junk=\"FunCBRTest message\"></Order>";

	public FunCBRTest(String name) {
		super(name);
	} /* method */

	public void testMessage() throws Exception {
	    clearMessages() ;
	    sendMessage() ;
	    final String[] messages = waitForMessages(1, 30000) ;
	    assertTrue("XML Content", Helpers.compareXMLContent(theXML, messages[0])) ;
	} /* method */

	public void sendMessage() throws Exception {
		SendJMSMessage sm = new SendJMSMessage();
		sm.setupConnection();
		sm.sendAMessage(theXML);
		sm.stop();
	} /* method */

   public static Test suite() throws Exception {
      return getDeploySetup(FunCBRTest.class, "QuickstartMessageStoreServer.sar, Quickstart_fun_cbr.esb");
   } /* method */
   
} /* class */
