/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.scheduler.ejbtimer;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.jbpm.JbpmConfiguration;
import org.jbpm.svc.JbpmServiceException;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.1 $ $Date: 2007/07/05 09:29:26 $
 */
public class EjbSchedulerServiceFactory implements ServiceFactory {

  // injected objects, see jbpm.cfg.xml
  private JbpmConfiguration jbpmConfiguration;
  private String schedulerControlHomeName;

  private SchedulerControlHome schedulerControlHome;

  private static final long serialVersionUID = 1L;

  public JbpmConfiguration getJbpmConfiguration() {
    return jbpmConfiguration;
  }

  public synchronized SchedulerControlHome getSchedulerControlHome() {
    if (schedulerControlHome == null) {
      if (schedulerControlHomeName == null) {
        throw new JbpmServiceException(
            "scheduler control home name not specified in jbpm configuration");
      }
      try {
        schedulerControlHome = (SchedulerControlHome) lookup(schedulerControlHomeName);
      }
      catch (NamingException e) {
        throw new JbpmServiceException("could not retrieve scheduler control home", e);
      }
    }
    return schedulerControlHome;
  }

  public Service openService() {
    return new EjbSchedulerService(this);
  }

  public void close() {
    schedulerControlHome = null;
  }

  private static Object lookup(String name) throws NamingException {
    InitialContext initialContext = new InitialContext();
    try {
      return initialContext.lookup(name);
    }
    finally {
      initialContext.close();
    }
  }
}
