/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.scheduler.ejbtimer;

import java.io.Serializable;

import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.1 $ $Date: 2007/07/05 09:29:26 $
 */
public class TimerInfo implements Serializable {

  private final long timerId;
  private final String timerName;
  private final long tokenId;
  private final long processInstanceId;

  // DON'T CHANGE THE SERIALIZED COMPATIBILITY OF THIS CLASS LIGHTLY
  // unlike command messages, timers will be in the timer db for a long time.
  // when they fire, they should be deserializable !
  private static final long serialVersionUID = 1L;

  public TimerInfo(Timer timer) {
    timerId = timer.getId();
    timerName = timer.getName();

    Token token = timer.getToken();
    tokenId = token != null ? token.getId() : -1;

    ProcessInstance processInstance = timer.getProcessInstance();
    processInstanceId = processInstance != null ? processInstance.getId() : -1;
  }

  public long getProcessInstanceId() {
    return processInstanceId;
  }

  public long getTimerId() {
    return timerId;
  }

  public String getTimerName() {
    return timerName;
  }

  public long getTokenId() {
    return tokenId;
  }

  public boolean matches(String timerName, long tokenId) {
    return this.timerName != null
        && this.timerName.equals(timerName)
        && this.tokenId != -1
        && this.tokenId == tokenId;
  }

  public boolean matches(long processInstanceId) {
    return this.processInstanceId != -1 && this.processInstanceId == processInstanceId;
  }
}
