/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.basic;

import org.hibernate.Session;

import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.integration.def.InvokeAction;
import org.jbpm.graph.def.Action;

/**
 * Calls a one-way or request-response operation on an endpoint offered by a
 * partner.
 * @author Juan Cant
 * @version $Revision: 1.4 $ $Date: 2007/02/19 22:25:44 $
 */
public class Invoke extends Activity {

  private static final long serialVersionUID = 1L;

  public Invoke() {
  }

  public Invoke(String name) {
    super(name);
  }
  
  public InvokeAction getInvokeAction() {
    if (action == null)
      return null;

    if (action instanceof InvokeAction)
      return (InvokeAction) action;

    // reacquire proxy of the proper type
    Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
    InvokeAction invokeAction = (InvokeAction) hbSession.load(
        InvokeAction.class, new Long(action.getId()));

    // update action reference
    action = invokeAction;

    return invokeAction;
  }

  public void setAction(Action action) {
    if (!(action instanceof InvokeAction))
      throw new IllegalArgumentException("not an invoke action: " + action);
      
    this.action = action;
    action.setName(name);
  }

  public void accept(BpelVisitor visitor) {
    visitor.visit(this);
  }
}
