package org.jbpm.gd.common.notation;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class NotationMapping {

	private static Map JPDL_NOTATION_MAPPINGS;
	
	private static Map getJpdlNotationMappings() {
		if (JPDL_NOTATION_MAPPINGS == null) {
			initializeJpdlNotationMappings();
		}
		return JPDL_NOTATION_MAPPINGS;
	}
	
	private static void initializeJpdlNotationMappings() {
		JPDL_NOTATION_MAPPINGS = new HashMap();
		IConfigurationElement[] configurationElements =
			Platform.getExtensionRegistry().getConfigurationElementsFor("org.jbpm.gd.common.notationMappings");
		for (int i = 0; i < configurationElements.length; i++) {
			if (configurationElements[i].getName().equals("mapping")) {
				JPDL_NOTATION_MAPPINGS.put(
						configurationElements[i].getAttribute("semanticElement"), 
						configurationElements[i].getAttribute("notationElement"));
			}
		}
	}
	
	public static String getNotationElementId(String semanticElementId) {
		return (String)getJpdlNotationMappings().get(semanticElementId);
	}
}
