package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Mail;
import org.jbpm.gd.jpdl.model.Node;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.Transition;

public class NodeDomAdapter extends JpdlElementDomAdapter {
	
	private static final String[] CHILD_ELEMENTS = {"action-element", "event", "exception-handler", "timer", "transition"};
	private static HashMap NODE_TYPES = null;
	
	protected String[] getChildElements() {
		return CHILD_ELEMENTS;
	}
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("action", "action-element");
			NODE_TYPES.put("script", "action-element");
			NODE_TYPES.put("create-timer", "action-element");
			NODE_TYPES.put("cancel-timer", "action-element");
			NODE_TYPES.put("mail", "action-element");
			NODE_TYPES.put("event", "event");
			NODE_TYPES.put("exception-handler", "exception-handler");
			NODE_TYPES.put("timer", "timer");
			NODE_TYPES.put("transition", "transition");
		}
		return NODE_TYPES;
	}
	
	protected void initialize() {
		super.initialize();
		Node node = (Node)getJpdlElement();
		if (node != null) {
			setAttribute("async", node.getAsync());
			setAttribute("name", node.getName());
			addElement(node.getAction());
			addElement(node.getScript());
			addElement(node.getCreateTimer());
			addElement(node.getCancelTimer());
			addElement(node.getMail());
			addElements(node.getEvents());
			addElements(node.getExceptionHandlers());
			addElements(node.getTimers());
			addElements(node.getTransitions());
		}
	}

	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Node node = (Node)jpdlElement;
		node.setAsync(getAttribute("async"));
		node.setName(getAttribute("name"));
		node.addPropertyChangeListener(this);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("action".equals(evt.getPropertyName())) {
			setElement("action", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("script".equals(evt.getPropertyName())) {
			setElement("script", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("createTimer".equals(evt.getPropertyName())) {
			setElement("create-timer", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("cancelTimer".equals(evt.getPropertyName())) {
			setElement("cancel-timer", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("mail".equals(evt.getPropertyName())) {
			setElement("mail", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("eventAdd".equals(evt.getPropertyName())) {
			addElement((Event)evt.getNewValue());
		} else if ("eventRemove".equals(evt.getPropertyName())) {
			removeElement((Event)evt.getOldValue());
		} else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
			addElement((ExceptionHandler)evt.getNewValue());
		} else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
			removeElement((ExceptionHandler)evt.getOldValue());
		} else if ("timerAdd".equals(evt.getPropertyName())) {
			addElement((Timer)evt.getNewValue());
		} else if ("timerRemove".equals(evt.getPropertyName())) {
			removeElement((Timer)evt.getOldValue());
		} else if ("transitionAdd".equals(evt.getPropertyName())) {
			addElement((Transition)evt.getNewValue());
		} else if ("transitionRemove".equals(evt.getPropertyName())) {
			removeElement((Transition)evt.getOldValue());
		} else if ("async".equals(evt.getPropertyName())) {
			setAttribute("async", (String)evt.getNewValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Node node = (Node)getJpdlElement();
		if ("name".equals(name)) {
			node.setName(newValue);
		} else if ("async".equals(name)) {
			node.setAsync(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Node node = (Node)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(type);
		child.initialize(jpdlElement);
		if ("action".equals(type)) {
			node.setAction((Action)jpdlElement);
		} else if ("script".equals(type)) {
			node.setScript((Script)jpdlElement);
		} else if ("create-timer".equals(type)) {
			node.setCreateTimer((CreateTimer)jpdlElement);
		} else if ("cancel-timer".equals(type)) {
			node.setCancelTimer((CancelTimer)jpdlElement);
		} else if ("mail".equals(type)) {
			node.setMail((Mail)jpdlElement);
		} else if ("event".equals(type)) {
			node.addEvent((Event)jpdlElement);
		} else if ("exception-handler".equals(type)) {
			node.addExceptionHandler((ExceptionHandler)jpdlElement);
		} else if ("timer".equals(type)) {
			node.addTimer((Timer)jpdlElement);
		} else if ("transition".equals(type)) {
			node.addTransition((Transition)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Node node = (Node)getJpdlElement();
		if ("action".equals(type)) {
			node.setAction(null);
		} else if ("script".equals(type)) {
			node.setScript(null);
		} else if ("create-timer".equals(type)) {
			node.setCreateTimer(null);
		} else if ("cancel-timer".equals(type)) {
			node.setCancelTimer(null);
		} else if ("mail".equals(type)) {
			node.setMail(null);
		} else if ("event".equals(type)) {
			node.removeEvent((Event)child.getJpdlElement());
		} else if ("exception-handler".equals(type)) {
			node.removeExceptionHandler((ExceptionHandler)child.getJpdlElement());
		} else if ("timer".equals(type)) {
			node.removeTimer((Timer)child.getJpdlElement());
		} else if ("transition".equals(type)) {
			node.removeTransition((Transition)child.getJpdlElement());
		}
	}



}
